function init()
    m.top.functionName = "changeParentalPassword"
end function

function changeParentalPassword()

    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    parpassDTO = {
        parpass: m.top.parpass,
    }
    user = getUserFromSection()
    provider = getProviderFromSection()
    url = "https://" + provider + "/self/accounts?t=" + user.token
    request.SetUrl("https://" + provider + "/self/accounts?t=" + user.token)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.SetRequest("PUT")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    body = FormatJson(parpassDTO, 1)

    if (request.AsyncPostFromString(body))
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")

            code = msg.GetResponseCode()
            response = msg.GetString()
            if (code = 200)
                parentalResponseDTO = ParseJSON(msg.GetString())
                parentalResponseDTO = {
                    status: "ok",
                    msg: tr("ok")
                }
            else
                parentalResponseDTO = {
                    status: "unexpected",
                    data: {},
                    msg: tr("Erro inesperado, entre em contato com seu provedor de internet.") + " (" + Str(code) + " )"
                }
            end if
            m.top.parentalResponseDTO = FormatJson(parentalResponseDTO)
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end function


