sub init()
    m.top.functionName = "getSendEmailResponse"
end sub

sub getSendEmailResponse() as string
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    sendEmailDTO = {
        email: m.top.email,
        name: m.top.name
        providerURL: m.top.providerURL,
        vodId: m.top.vodId,
        tbox: "3e24d3fe3f6799b663b1e1b5ad14477ac5ddded7"
    }
    print sendEmailDTO

    now = CreateObject("roDateTime")

    url = "https://" + sendEmailDTO.providerURL + "/email/purchase?providerUrl=" + sendEmailDTO.providerURL + "&user=" + sendEmailDTO.name + "&email=" + sendEmailDTO.email + "&movie_name=" + sendEmailDTO.vodId + "&tbox=" + sendEmailDTO.tbox
    print url
    request.SetUrl(url)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    body = FormatJson(sendEmailDTO, 1)
    if (request.AsyncPostFromString(body))
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            print "/email/purchase status=" + StrI(code)
            if (code = 200)
                response = ParseJSON(msg.GetString())
                sendEmailResponseDTO = {
                    createdAt: now.AsSeconds(),
                    status: "ok",
                    data: {},
                }
            else
                sendEmailResponseDTO = {
                    createdAt: now.AsSeconds(),
                    status: "unexpected",
                    data: {},
                    msg: "Erro inesperado, entre em contato com seu provedor de internet. (" + Str(code) + " )"
                }
            end if
            m.top.sendEmailResponseDTO = FormatJson(sendEmailResponseDTO)
            return m.top.sendEmailResponseDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end sub