function init()
    m.top.setFocus(true)
    m.channelId = getCurrentChannelFromSection()
    m.overlay = m.top.findNode("overlay")
 
    if m.channelId = invalid
        return invalid
    end if
    
    m.parentalControlBody = m.top.findNode("parentalControlBody")
    m.allChannels = m.top.findNode("allchannels")
    m.allChannels.text = tr("Todos os canais")
    m.parentalControlPinPad = m.top.findNode("parentalControlPinPad")
    setCurrentTime()
    m.providerURL = getProviderFromSection()
    m.user = getUserFromSection()
    runGetChannelTask()
    runGetChannelsTask()
    m.epgRect = m.top.findNode("EPGRect")
    m.epgHeaderReact = m.top.findNode("EPGHeaderReact")
    m.channelsRect = m.top.findNode("ChannelsRect")
end function

function setHLSContent(url as string)
    ContentNode = CreateObject("roSGNode", "ContentNode")
    ContentNode.streamFormat = "hls"
    ContentNode.url = url
    m.Video.content = ContentNode
end function

function play()
    m.Video.visible = "true"
    m.Video.control = "play"
    m.Video.ObserveField("state", "stateListener")
end function

function setDRMContent(url as string)
    drmParams = {
        keySystem: "Widevine"
        licenseServerURL: "https://widevine-dash.ezdrm.com/widevine-php/widevine-foreignkey.php?pX=1F9802"
    }
    ContentNode = CreateObject("roSGNode", "ContentNode")
    ContentNode.streamFormat = "dash"
    ContentNode.url = url
    ContentNode.drmParams = drmParams
    m.Video.content = ContentNode
end function

function runGetChannelTask()
    m.channelTask = m.top.findNode("ChannelTask")
    m.channelTask.control = "RUN"
    m.channelTask.channelId = m.channelId
    m.channelTask.providerURL = m.providerURL
    m.channelTask.token = m.user.token
    m.channelTask.observeField("channelDTO", "getChannelListener")
end function

function runGetEPGTask()
    m.EPGTask = m.top.findNode("EPGTask")
    m.EPGTask.control = "RUN"
    m.EPGTask.guideId = m.currentChannel.guide
    m.EPGTask.providerURL = m.providerURL
    m.EPGTask.token = m.user.token
    m.EPGTask.observeField("epgListResponseDTO", "getEPGListener")
end function

function runGetChannelsTask()
    m.ChannelsTask = m.top.findNode("ChannelsTask")
    m.ChannelsTask.control = "RUN"
    m.ChannelsTask.providerURL = m.providerURL
    m.ChannelsTask.token = m.user.token
    m.ChannelsTask.observeField("channelsListDTO", "getChannelsListener")
end function

function getChannelsListener()
    if m.ChannelsTask.channelsListDTO = invalid
        return invalid
    end if
    m.channelsListDTO = m.ChannelsTask.channelsListDTO
    m.channelsMarkupList = m.top.findNode("channelsListMenu")
    content = mapChannelsListDTOToNodeContent(m.channelsListDTO)
    m.channelsMarkupList.content = content
    m.channelsMarkupList.ObserveField("itemSelected", "onChannelSelectedListener")
    m.channelsMarkupList.ObserveField("itemFocused", "onItemFocusedListener")
end function

function onItemFocusedListener()
    autoHideOverlay()
end function

function onChannelSelectedListener() as dynamic
    print "onChannelSelectedListener"
    if not isOverlayShowing()
        return invalid
    end if
    selectedChannel = m.channelsMarkupList.content.getChild(m.channelsMarkupList.itemFocused)
    m.channelId = selectedChannel.id
    runGetChannelTask()
    hideOverlay()
end function

function mapChannelsListDTOToNodeContent(channelsListDTO) as dynamic
    content = createObject("roSGNode", "ContentNode")
    m.channelsIdsMap = CreateObject("roAssociativeArray") 
    channelCount = channelsListDTO.count()
    previousChannel = invalid
    for i = 0 to (channelCount - 1)
        content_child = content.createChild("ContentNode")
        content_child.title = Str(channelsListDTO[i].number) + " - " + channelsListDTO[i].name
        content_child.id = channelsListDTO[i].id
        m.channelsIdsMap.AddReplace(Str(i), channelsListDTO[i].id)
        currentChanelId = m.currentChannel.id
        if currentChanelId = invalid
            currentChanelId = 0
        endif

        if channelsListDTO[i].id = currentChanelId
            if i-1 >= 0
                m.previousChannelId = channelsListDTO[i-1].id
                m.currentChanelListPlace = i
            else
                m.previousChannelId = channelsListDTO[channelCount-1].id
                m.currentChanelListPlace = channelCount-1
            end if

            if i <= channelCount
                m.nextChannelId = channelsListDTO[i].id
                m.currentChanelListPlace = i
            else
                m.nextChannelId = channelsListDTO[0].id
                m.currentChanelListPlace = 0
            end if
        end if
    end for
    return content
end function

function getPreviousChanelId()
    currentChanelListPlace = m.currentChanelListPlace 
    if m.currentChanelListPlace = invalid then return invalid
    previous = m.currentChanelListPlace - 1
    if previous >= 0
        m.currentChannelIdList = m.channelsIdsMap.Lookup(Str(previous))
        m.currentChanelListPlace = previous
    else
        m.currentChannelIdList = m.channelsIdsMap.Lookup(Str(m.channelsIdsMap.count() - 1))
        m.currentChanelListPlace = m.channelsIdsMap.count() - 1
    end if

end function

function getNextChanelId()
    currentChanelListPlace = m.currentChanelListPlace 
    if m.currentChanelListPlace = invalid then return invalid
    nextChannel = m.currentChanelListPlace + 1
    if nextChannel <= m.channelsIdsMap.count() - 1
        m.currentChannelIdList = m.channelsIdsMap.Lookup(Str(nextChannel))
        m.currentChanelListPlace = nextChannel
    else
        m.currentChannelIdList = m.channelsIdsMap.Lookup(Str(0))
        m.currentChanelListPlace = 0
    end if
    
end function

function getEPGListener()
    if m.EPGTask.epgListResponseDTO = invalid
        return invalid
    end if
    m.epgStart = m.top.findNode("EPGStart")
    m.epgEnd = m.top.findNode("EPGEnd")
    m.epgStartTime = m.top.findNode("EPGStartTime")
    m.epgEndTime = m.top.findNode("EPGEndTime")
    m.now = m.top.findNode("now")
    m.next = m.top.findNode("next")
    m.next.text = tr("A seguir") + " "

    if m.EPGTask.epgListResponseDTO.count() = 0
        m.now.text = ""
        m.next.text = ""
        m.epgStart.text = ""
        m.epgStartTime.text = ""
        m.epgEnd.text = ""
        m.epgEndTime.text = ""
        return invalid
    end if

    m.now.text = tr("Agora") + " "
    m.next.text = tr("A seguir") + " "
    m.epgStart.text = m.EPGTask.epgListResponseDTO[0].title
    m.epgStartTime.text = getHourAndMinuteFromStr(m.EPGTask.epgListResponseDTO[0].start) + " - " + getHourAndMinuteFromStr(m.EPGTask.epgListResponseDTO[0].stop)
    m.epgEnd.text = m.EPGTask.epgListResponseDTO[1].title
    m.epgEndTime.text = getHourAndMinuteFromStr(m.EPGTask.epgListResponseDTO[1].start) + " - " + getHourAndMinuteFromStr(m.EPGTask.epgListResponseDTO[1].stop)
    print formatJson(m.EPGTask.epgListResponseDTO)
end function

function setCurrentTime()
    m.currentTime = m.top.findNode("currentTime")
    m.timer = CreateObject("roSGNode", "Timer")
    m.timer.id = "timeRefresh"
    m.timer.repeat = true
    m.timer.duration = 10
    m.timer.control = "start"
    m.timer.ObserveField("fire", "timeListener")
    m.currentTime.text = getCurrentHourAndMinute()
end function

function timeListener()
    m.currentTime.text = getCurrentHourAndMinute()
end function

function getHourAndMinuteFromStr(dateString as string) as string
    date = CreateObject("roDateTime")
    date.FromISO8601String(dateString)
    hours = date.getHours().toStr()
    minutes = date.GetMinutes().toStr()

    if len(hours) = 1
        hours = "0" + hours
    end if

    if len(minutes) = 1
        minutes = "0" + minutes
    end if

    return hours + ":" + minutes
end function

function getCurrentHourAndMinute() as string
    date = CreateObject("roDateTime")
    date.toLocalTime()

    hours = date.getHours().toStr()
    minutes = date.GetMinutes().toStr()

    if len(hours) = 1
        hours = "0" + hours
    end if

    if len(minutes) = 1
        minutes = "0" + minutes
    end if

    return hours + ":" + minutes
end function

function getChannelListener()
    if m.channelTask.channelDTO = invalid
        return invalid
    end if

    m.currentChannel = ParseJson(m.channelTask.channelDTO)
    m.Video = m.top.findNode("Video")
    m.logo = m.top.findNode("logo")
    m.channelName = m.top.findNode("channelName")
    m.logo.uri = ""

    if m.currentChannel.logo <> invalid
        m.logo.uri = "https://" + m.providerURL + m.currentChannel.logo + "_160_160"
    end if

    m.channelName.text = Str(m.currentChannel.number) + " - " + m.currentChannel.name

    if m.currentChannel.dash <> invalid
        setDRMContent("https://" + m.providerURL + "" + m.currentChannel.dash + "&t=" + m.user.token)
    else
        setHLSContent("https://" + m.providerURL + "" + m.currentChannel.hls + "&t=" + m.user.token)
    end if

    if shouldCheckParentalControl()
        checkParentalControl()
    else
        playContent()
    end if

end function

function shouldCheckParentalControl() as boolean
    inRating = m.currentChannel.rating >= m.user.rating 

    if inRating and getLastChannelFromSection() >= m.user.rating 
        return false
    end if

    if inRating = false
        setLastChannelOnSection(m.currentChannel.rating)
    end if

    return inRating
end function

function setLastChannelOnSection(channelId) as void
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("lastChannelRating", Str(channelId))
    section.Flush()
end function

function getLastChannelFromSection() as integer
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("lastChannelRating")
        return section.Read("lastChannelRating").toInt()
    end if
    return 0
end function

function playContent()
    play()
    runGetEPGTask()
end function

function checkParentalControl()
    m.parentalControlBody.visible = true
    m.parentalControlPinPad.setFocus(true)
    m.parentalControlPinPad.observeField("pin", "pinPadTextChangeListener")
end function

function pinPadTextChangeListener()
    if len(m.parentalControlPinPad.pin) < 4 then return invalid
    pinToSHA1 = convertToSHA1(m.parentalControlPinPad.pin)
    m.pinErrorMsg = m.top.findNode("pinErrorMsg")
    m.pinErrorMsg.text = tr("Senha Inválida!")
    if m.user.parpass <> pinToSHA1
        m.parentalControlPinPad.pin = ""
        m.pinErrorMsg.visible = true
        return invalid
    end if

    setLastChannelOnSection(m.currentChannel.rating)

    m.parentalControlPinPad.pin = ""
    m.pinErrorMsg.visible = false
    m.parentalControlBody.visible = false
    m.parentalControlBody.setFocus(false)
    m.top.setFocus(true)
    playContent()
end function

function convertToSHA1(text as string) as string
    bytearray = CreateObject("roByteArray")
    bytearray.FromAsciiString(text)
    digest = CreateObject("roEVPDigest")
    digest.Setup("sha1")
    return digest.Process(bytearray)
end function

function stateListener()
    if m.Video.state = "error"
        print "Content"; m.Video.content
        print "errorCode: ";m.Video.errorCode
        print "errorStr: "; m.Video.errorStr
        print "errorInfo: "; m.Video.errorStr
        print "errorMsg: "; m.Video.errorMsg

        dialog = createObject("roSGNode", "Dialog")
        dialog.id = "playerError"
        dialog.title = tr("Erro ao carregar conteúdo")
        dialog.message = tr("Não foi possível carregar, tente novamente mais tarde.")
        showDialog(dialog)
    end if

end function

function autoHideOverlay()
    m.autoHide = CreateObject("roSGNode", "Timer")
    m.autoHide.id = "autoHideOverlay"
    m.autoHide.repeat = false
    m.autoHide.duration = 5
    m.autoHide.control = "start"
    m.autoHide.ObserveField("fire", "autoHideOverlayListener")
end function

function autoHideOverlayListener()
    hideOverlay()
    m.top.setFocus(true)
end function

function getCurrentChannelFromSection()
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("currentChannelId")
        return section.Read("currentChannelId")
    end if
    return invalid
end function

function stopVideo()
    m.Video.visible = false
    m.Video.control = "stop"
end function

function isOverlayShowing() as boolean
    return m.overlay.opacity > 0
end function

function hideOverlay() as void
    m.overlay.opacity = 0
    m.epgRect.opacity = 0
    m.epgHeaderReact.opacity = 0
    m.channelsRect.opacity = 0
end function

function showOverlay() as void
    m.overlay.opacity = 0.9
end function

function showSideBarMenuChannels() as void
    showOverlay()
    m.epgRect.opacity = 0.0
    m.epgHeaderReact.opacity = 0.0
    m.channelsRect.opacity = 1
    m.channelsMarkupList.setFocus(true)
end function

function shouldExitScreen(key) as boolean
    return key = "back" and not isOverlayShowing()
end function

function exitScreen() as void
    stopVideo()
    redirectScreenTo("ChannelsScene")
end function

function shouldHideOverlay(key) as boolean
    return key = "back" and isOverlayShowing()
end function

function shouldShowSideBarMenuChannels(key) as boolean
    return key = "left" and not isOverlayShowing() or key = "left" and isOverlayShowing() and m.epgRect.hasFocus()
end function

function shouldHideOverlayOnEPG(key) as boolean
    return key = "OK" and isOverlayShowing() and m.epgRect.hasFocus()
end function

function shouldDisplayEPGWhenSidebarFocused(key) as boolean
    return key = "right" and isOverlayShowing() and m.channelsMarkupList.hasFocus()
end function

function displayEPGWhenSidebarFocused() as void
    m.epgRect.opacity = 1
    m.epgHeaderReact.opacity = 1
    m.channelsRect.opacity = 0
    m.epgRect.setFocus(true)
end function

function shouldShowEPG(key) as boolean
    return key = "OK" and not isOverlayShowing() and m.parentalControlBody.visible = false
end function

function showEPG() as void
    showOverlay()
    m.epgRect.opacity = 1
    m.epgHeaderReact.opacity = 1
    m.epgRect.setFocus(true)
end function

function onKeyEvent(key as string, press as boolean) as boolean
    handled = false
    if press
        if (key = "up")
            print("pra cima")
            getNextChanelId()
            selectedChannel = m.currentChannelIdList
            print(selectedChannel)
            m.channelId = selectedChannel
            runGetChannelTask()
            if(not isOverlayShowing())
                showEPG()
            end if
        else if (key = "down")
            print("pra baixo")
            getPreviousChanelId()
            selectedChannel = m.currentChannelIdList
            print(selectedChannel)
            m.channelId = selectedChannel
            runGetChannelTask()
            if(not isOverlayShowing())
                showEPG()
            end if
        else if shouldExitScreen(key)
            exitScreen()
            handled = true
        else
            handled = true
        end if
    else
        if shouldShowEPG(key)
            showEPG()
            handled = true
        else if shouldShowSideBarMenuChannels(key)
            showSideBarMenuChannels()
            handled = true
        else if shouldHideOverlayOnEPG(key)
            hideOverlay()
            m.top.setFocus(true)
            handled = true
        else if shouldDisplayEPGWhenSidebarFocused(key)
            displayEPGWhenSidebarFocused()
            handled = true
        else if shouldHideOverlay(key)
            hideOverlay()
            m.top.setFocus(true)
            handled = true
        end if
        autoHideOverlay()
    end if
    return handled
end function
