sub Main(args as dynamic)
  showScreen(args)
end sub

sub showScreen(args as dynamic)
  screen = CreateObject("roSGScreen")
  m.port = CreateObject("roMessagePort")
  input = CreateObject("roInput")
  input.SetMessagePort(m.port)
  screen.setMessagePort(m.port)
  scene = screen.CreateScene("MainScene")

  m.global = screen.getGlobalNode()
  deeplink = getDeepLinks(args)
  m.global.addField("deeplink", "assocarray", false)
  m.global.deeplink = deeplink

  screen.show()

  m.exit_app = scene.findNode("exitApp")
  m.exit_app.observeField("text", m.port)

  while(true)
    msg = wait(0, m.port)
    msgType = type(msg)
    if msgType = "roSGScreenEvent"
      if msg.isScreenClosed() then return
    else if msgType = "roSGNodeEvent"
      field = msg.getField()
      data = msg.getData()
      if data = "close" and field = "text" then end
    else if msgType = "roInputEvent"
      info = msg.GetInfo()
      deeplink = getDeepLinks(info)
      m.global.deeplink = deeplink
      print "Received input: "; formatJSON(info)
      print "deeplink: "; m.global.deeplink
    end if
  end while
end sub


function getDeepLinks(args)
  deeplink = invalid

  if args.contentid <> invalid and args.mediaType <> invalid
    deeplink = {
      contentId: args.contentId
      mediaType: args.mediaType
    }
  end if

  return deeplink
end function