function init()
    m.top.functionName = "getAuthResponse"
end function

function getAuthResponse()
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    provider = getProviderFromSection()
    user = getUserFromSection()

    authRefreshTokenDTO = {
        token: user.rtoken
    }

    url = "https://" + provider + "/auth"
    request.SetUrl("https://" + provider + "/auth")
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    body = FormatJson(authRefreshTokenDTO, 1)
    if (request.AsyncPostFromString(body))
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            print "/auth status=" + StrI(code)
            if (code = 200)
                response = ParseJSON(msg.GetString())
                authResponseDTO = {
                    status: "ok",
                    data: {
                        economic: response.economic,
                        expire: response.expire,
                        lifetime: response.lifetime,
                        parental: response.parental,
                        parpass: response.parpass,
                        rating: handleRatingType(response.rating),
                        svod: response.svod,
                        token: response.token,
                        validated_email: response.validated_email
                    },
                }
            else if (code = 401)
                authResponseDTO = {
                    status: "unauthorized",
                    data: {},
                    msg: "Credenciais de acesso inválidas. (" + Str(code) + " )"
                }
            else if (code = 403)
                authResponseDTO = {
                    status: "forbidden",
                    data: {},
                    msg: "Usuário bloqueado. (" + Str(code) + " )"
                }
            else if (code = 429)
                authResponseDTO = {
                    status: "forbidden",
                    data: {},
                    msg: "Máximo de sessões atingidas. (" + Str(code) + " )"
                }
            else
                authResponseDTO = {
                    status: "unexpected",
                    data: {},
                    msg: "Erro inesperado, entre em contato com seu provedor de internet. (" + Str(code) + " )"
                }
            end if
            m.top.authResponseDTO = FormatJson(authResponseDTO)
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end function

function handleRatingType(rating) as integer
    if type(rating) = "Integer" then return rating
    return rating.toInt()
end function
