function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    m.vodName = getVodName()
    m.channelStore = createObject("roSGNode", "channelStore")
    m.channelStore.observeField("requestPartnerOrderStatus", "requestPartnerOrderStatusChanged")
    m.channelStore.observeField("confirmPartnerOrderStatus", "confirmPartnerOrderStatusChanged")
    m.channelStore.observeField("userData", "requestedUserDataInfoChanged")
    setLastSelectedVODOnGlobal(m.vodName)
    m.mainLogo = m.top.findNode("mainLogo")
    m.mainLogo.uri = "https://" + m.providerURL + "/logo/main-logo.png_150_150"
    loadRefreshToken()
    loadCurrentVOD()
    m.top.visible = true
    m.menu = m.top.findNode("menu")
    m.actionBtn = m.top.findNode("actionBtn")
    m.top.setFocus(false)
    m.actionBtn.setFocus(true)
    m.menu.observeField("itemSelected", "itemSelectedListener")

end function

function setLastSelectedVODOnGlobal(name) as void
    m.global.addField("lastSelectedVOD", "string", false)
    m.global.lastSelectedVOD = m.vodName
end function

function itemSelectedListener()
    selectedItem = m.menu.content.getChild(m.menu.itemFocused)
    if selectedItem.id = "profile"
        redirectScreenTo("ProfileScene")
    else if selectedItem.id = "channels"
        redirectScreenTo("ChannelsScene")
    else if selectedItem.id = "vod"
        redirectScreenTo("VodsScene")
    end if
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"
end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

end function

function loadCurrentVOD()
    m.VODDetailsTask = m.top.findNode("VODDetailsTask")
    m.VODDetailsTask.vodName = m.vodName
    m.VODDetailsTask.email = m.user.email
    m.VODDetailsTask.user = m.user.username
    m.VODDetailsTask.providerURL = m.providerURL
    m.VODDetailsTask.control = "RUN"
    m.VODDetailsTask.observeField("VODDetailsDTO", "VODDetailsTaskListener")
end function

function VODDetailsTaskListener()
    if m.VODDetailsTask.VODDetailsDTO = invalid then return invalid
    if m.VODDetailsTask.VODDetailsDTO.status = "NOT_FOUND" then return invalid

    m.VODDetailsDTO = m.VODDetailsTask.VODDetailsDTO.data

    m.vodNameNode = m.top.findNode("vodName")
    m.vodReleaseYear = m.top.findNode("vodReleaseYear")
    m.vodGenres = m.top.findNode("vodGenres")
    m.vodSynopsis = m.top.findNode("vodSynopsis")
    m.vodDuration = m.top.findNode("vodDuration")
    m.vodSeasons = m.top.findNode("vodSeasons")
    m.body = m.top.findNode("body")
    m.seasonsZoomList = m.top.findNode("seasonsZoomList")

    m.vodNameNode.text = m.VODDetailsDTO.title
    m.vodReleaseYear.text = m.VODDetailsDTO.releaseYear
    m.vodGenres.text = m.VODDetailsDTO.genres
    m.vodSynopsis.text = m.VODDetailsDTO.synopsis
    m.body.uri = m.VODDetailsDTO.poster

    m.accountTvodTask = createObject("roSGNode", "AccountTvodTask")
    m.accountTvodTask.AccountTvodDto = { providerURL: m.providerURL, email: m.user.email, vodId: m.vodName }
    m.accountTvodTask.control = "RUN"
    m.accountTvodTask.observeField("AccountTvodResponseDto", "AccountTvodResponseDtoChanged")

    m.actionBtn.observeField("buttonSelected", "actionButtonOnButtonSelected")
    m.top.setFocus(false)
    m.actionBtn.setFocus(true)
end function

function AccountTvodResponseDtoChanged()
    if m.accountTvodTask.AccountTvodResponseDto = invalid then return invalid
    if m.VODDetailsDTO.selling = true and m.accountTvodTask.AccountTvodResponseDto.data = false then
        m.actionBtn.text = tr("Comprar")
        m.actionBtn.iconUri = "pkg:/images/shopping-cart-solid.png"
        m.actionBtn.focusedIconUri = "pkg:/images/shopping-cart-solid-121212.png"
    else
        m.actionBtn.text = tr("Assistir")
        m.actionBtn.iconUri = "pkg:/images/play-solid.png"
        m.actionBtn.focusedIconUri = "pkg:/images/play-solid-121212.png"
    end if
    if m.VODDetailsDTO.vodType = "SINGLEMEDIA" then m.vodDuration.text = tr("Duração") + ": " + m.VODDetailsDTO.duration
    if m.VODDetailsDTO.vodType = "MULTIMEDIA" then m.vodSeasons.text = Str(m.VODDetailsDTO.seasons) + " " + tr("Temporada")
    if m.VODDetailsDTO.vodType = "MULTIMEDIA" then loadRowListSeasons()

end function

function loadRowListSeasons()
    m.RowListSeasonsTask = createObject("roSGNode", "RowListSeasonsTask")
    m.RowListSeasonsTask.seasonsListDTO = m.VODDetailsDTO.seasonsList
    m.RowListSeasonsTask.observeField("content", "RowListSeasonsListener")
    m.RowListSeasonsTask.control = "RUN"
end function

function actionButtonOnButtonSelected()
    if m.VODDetailsDTO.selling and m.accountTvodTask.AccountTvodResponseDto.data = false
        m.sendEmailTask = m.top.findNode("SendEmailTask")
        m.sendEmailTask.name = m.user.username
        m.sendEmailTask.email = m.user.email
        m.sendEmailTask.providerURL = m.providerURL
        m.sendEmailTask.vodId = m.vodName

        m.orderInfo = createObject("roSGNode", "contentNode")
        m.orderInfo.title = m.VODDetailsDTO.title
        m.orderInfo.priceDisplay = formatTwoDigitFloat(m.VODDetailsDTO.price)
        m.orderInfo.price = formatTwoDigitFloat(m.VODDetailsDTO.price)
        m.orderInfo.origPrice = formatTwoDigitFloat(m.VODDetailsDTO.price)
        m.orderInfo.contentKey = m.vodName
        m.orderInfo.addField("code", "string", false)
        m.orderInfo.code = "tvodcdntv"
        m.channelStore.requesteduserdata = "firstname, email, phone, city, state, zip, country, phone, street1"
        m.channelStore.command = "getUserData"

    else
        if m.VODDetailsDTO.vodType = "MULTIMEDIA" then setSeasonEpisode(0, 0)
        setVODDetailsDTO(formatJSON(m.VODDetailsDTO))
        setVodName(m.vodName)
        redirectScreenTo("VODPlayerScene")
    end if

end function

function requestedUserDataInfoChanged() as void
    if m.channelStore.userData = invalid then return
    m.channelStore.requestPartnerOrder = m.orderInfo
    m.channelStore.command = "requestPartnerOrder"

end function

function requestPartnerOrderStatusChanged() as void
    if m.channelStore.requestPartnerOrderStatus.status = "Success"
        confirmPurchase()
    else
        ? "Erro "; m.channelStore.requestPartnerOrderStatus.status
    end if
end function

sub confirmPurchase()
    ? "m.channelStore.requestPartnerOrderStatus"; m.channelStore.requestPartnerOrderStatus
    m.confirmRequest = CreateObject("roSGNode", "ContentNode")
    m.confirmRequest.title = m.VODDetailsDTO.title
    m.confirmRequest.priceDisplay = formatTwoDigitFloat(m.VODDetailsDTO.price)
    m.confirmRequest.price = formatTwoDigitFloat(m.VODDetailsDTO.price)
    m.confirmRequest.origPrice = formatTwoDigitFloat(m.VODDetailsDTO.price)
    m.confirmRequest.orderID = m.channelStore.requestPartnerOrderStatus.orderID
    m.confirmRequest.contentKey = m.vodName

    m.confirmRequest.addField("code", "string", false)
    m.confirmRequest.code = "tvodcdntv"

    m.channelStore.confirmPartnerOrder = m.confirmRequest

    ? "Issuing ConfirmPartnerOrder Command"
    ? "-- code: ", m.channelStore.confirmPartnerOrder.code
    ? "-- title: ", m.channelStore.confirmPartnerOrder.title
    ? "-- priceDisplay: ", m.channelStore.confirmPartnerOrder.priceDisplay
    ? "-- price: ", m.channelStore.confirmPartnerOrder.price
    ? "-- orderID: ", m.channelStore.confirmPartnerOrder.orderID
    m.channelStore.command = "confirmPartnerOrder"
end sub

function confirmPartnerOrderStatusChanged() as void
    response = m.channelStore.confirmPartnerOrderStatus
    ? "m.channelStore.confirmPartnerOrderStatus"; m.channelStore.confirmPartnerOrderStatus

    if response <> invalid and response.status = "Success"
        checkoutDTO = {}
        checkoutDTO["name"] = m.channelStore.userData.firstName
        checkoutDTO["email"] = m.user.email
        checkoutDTO["street"] = m.channelStore.userData.street1
        checkoutDTO["number"] = "0"
        checkoutDTO["city"] = m.channelStore.userData.city
        checkoutDTO["state"] = m.channelStore.userData.state
        checkoutDTO["country"] = m.channelStore.userData.country
        checkoutDTO["zip"] = m.channelStore.userData.zip
        checkoutDTO["phone"] = m.channelStore.userData.phone
        checkoutDTO["providerURL"] = m.providerURL
        checkoutDTO["price"] = m.VODDetailsDTO.price
        checkoutDTO["vodId"] = m.vodName
        checkoutDTO["transactionId"] = response.purchaseId
        checkoutDTO["transactionStatus"] = "paid"

        m.GWPagTask = CreateObject("roSGNode", "GWPagTask")
        m.GWPagTask.checkoutDTO = checkoutDTO
        m.GWPagTask.control = "RUN"
        m.GWPagTask.observeField("checkoutResponseDTO", "checkoutResponseDTOChanged")

        displayDialog(tr("Bom filme!"), tr("A compra da mídia") + " " + m.VODDetailsDTO.title + " " + tr("foi concluida com sucesso! Aguarde alguns instantes."))
        ? "GWPAGTask.checkout() "; checkoutDTO
    else
        displayDialog(tr("Não foi possível efetuar a compra"), tr("A compra da mídia") + " " + m.VODDetailsDTO.title + " " + tr("não foi concluida! ") + "(" + response.errorCode + ") " + tr("Detalhes") + ": " + response.errorMessage)
    end if


end function

function checkoutResponseDTOChanged()
    if m.GWPagTask.checkoutResponseDTO = invalid then return invalid

    result = m.GWPagTask.checkoutResponseDTO

    if result.status = "SUCCESS"
        m.vodAvailableTimer = CreateObject("roSGNode", "Timer")
        m.vodAvailableTimer.id = "isVodAvailable"
        m.vodAvailableTimer.repeat = true
        m.vodAvailableTimer.duration = 5
        m.vodAvailableTimer.ObserveField("fire", "checkVodIsAvailable")
        m.vodAvailableTimer.control = "start"

    else if result.status = "ERROR"
        ? "Error: "; result.msg
    end if
end function

function checkVodIsAvailable()
    ? "checkVodIsAvailable"
    m.isTvodAvailableTask = createObject("roSGNode", "AccountTvodTask")
    m.isTvodAvailableTask.AccountTvodDto = { providerURL: m.providerURL, email: m.user.email, vodId: m.vodName }
    m.isTvodAvailableTask.control = "RUN"
    m.isTvodAvailableTask.observeField("AccountTvodResponseDto", "isVodAvailableListener")
end function

function isVodAvailableListener()
    if m.isTvodAvailableTask.AccountTvodResponseDto = invalid then return invalid
    result = m.isTvodAvailableTask.AccountTvodResponseDto

    if result.data = false
        ? "Não disponível ainda."
        m.isTvodAvailableTask.AccountTvodResponseDto = invalid
    else
        m.vodAvailableTimer.control = "stop"
        redirectScreenTo("VODInternalScene")
    end if

end function

function RowListSeasonsListener() as dynamic
    if m.RowListSeasonsTask.content = invalid
        return invalid
    end if

    m.seasonsZoomList.content = m.RowListSeasonsTask.content
    m.seasonsZoomList.visible = true
    m.actionBtn.setFocus(false)
    m.seasonsZoomList.setFocus(true)
    m.seasonsZoomList.jumpToRowItem = getNodePositionByVodID(m.vodName)
    m.seasonsZoomList.observeField("rowItemSelected", "getSeasonEpisodeSelected")
end function

function getNodePositionByVodID(vod_id)
    row_index = 0
    while row_index < m.seasonsZoomList.content.getChildCount()
        row_children = m.seasonsZoomList.content.getChild(row_index)
        row_children_index = 0
        while row_children_index < row_children.getChildCount()
            vod_node = row_children.getChild(row_children_index)
            if vod_node.id = vod_id then return [row_index, row_children_index]
            row_children_index = row_children_index + 1
        end while
        row_index = row_index + 1
    end while

    return [0, 0]
end function

function getSeasonEpisodeSelected()
    seasonEpisodeDTO = setSeasonEpisode(m.seasonsZoomList.rowItemSelected[0], m.seasonsZoomList.rowItemSelected[1])
    setVODDetailsDTO(formatJSON(m.VODDetailsDTO))
    setVodName(seasonEpisodeDTO.episodeId)
    redirectScreenTo("VODPlayerScene")
end function

function setSeasonEpisode(season, episode)

    selectedSeason = m.seasonsZoomList.content.getChild(season)
    selectedEpisode = selectedSeason.getChild(episode)

    seasonEpisodeDTO = {
        seasonNumber: selectedSeason.id
        episodeId: selectedEpisode.id
    }

    setSelectedSeasonEpisodeOnSection(formatJson(seasonEpisodeDTO))
    return seasonEpisodeDTO

end function

sub setVODDetailsDTO(VODDetailsDTO)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("VODDetailsDTO", VODDetailsDTO)
    section.Flush()
end sub

function setSelectedSeasonEpisodeOnSection(seasonEpisodeDTO)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("selectedSeasonEpisode", seasonEpisodeDTO)
    section.Flush()
end function

function shouldFocusCarrousel(key) as boolean
    if key = "down" and m.actionBtn.hasFocus() and m.seasonsZoomList.visible = true then return true
    return false
end function

sub displayDialog(title, message)
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "emailConfirmation"
    dialog.title = title
    dialog.message = message
    showDialog(dialog)
end sub

function formatTwoDigitFloat(val as dynamic) as string
    if val = invalid then return ""

    price = Val(val)
    formattedVal = Str(((price * 100) + 0.1) / 100)
    price_str = Left(formattedVal, Len(formattedVal) - 1)

    return price_str .Replace(" ", "")
end function

function onKeyEvent(key as string, press as boolean) as boolean
    print "in ChannelScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if (key = "back" or key = "left") and (m.menu.hasFocus() = false)
            m.actionBtn.setFocus(false)
            m.menu.setFocus(true)
        else if key = "back" and m.menu.hasFocus()
            redirectScreenTo("VodsScene")
        else if key = "right"
            m.actionBtn.setFocus(true)
        else if key = "up" and m.seasonsZoomList.hasFocus()
            m.actionBtn.setFocus(true)
        else if shouldFocusCarrousel(key)
            m.seasonsZoomList.setFocus(true)
        end if
        handled = true
    else
        handled = true

    end if
    return handled
end function
