function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    m.mainLogo = m.top.findNode("mainLogo")
    m.mainLogo.uri = "https://" + m.providerURL + "/logo/main-logo.png_150_150"
    m.logout = m.top.findNode("logout")
    m.logout.setFocus(true)
    loadRefreshToken()

    m.VODsTask = createObject("roSGNode", "VODsTask")
    m.VODsTask.token = m.user.token
    m.VODsTask.email = m.user.email
    m.VODsTask.username = m.user.username
    m.VODsTask.providerURL = m.providerURL
    m.VODsTask.control = "RUN"
    m.VODsTask.observeField("VODCategoriesListDTO", "VODsOnLoad")

    m.menu = m.top.findNode("menu")
    m.menu.observeField("itemSelected", "itemSelectedListener")
    
    m.logout.observeField("buttonSelected", "onButtonSelectedListener")
    m.logout.text = tr("Logout")
    m.name = m.top.findNode("name")
    m.email = m.top.findNode("email")
    m.name.text = tr("Bem vindo") + ", " + m.user.username
    m.email.text = m.user.email
end function

function VODsOnLoad()
    shouldDisplayVod = true
    if m.VODsTask.VODCategoriesListDTO.hasError then shouldDisplayVod = false

    loadMenu(shouldDisplayVod)
endfunction

function loadMenu(shouldDisplayVod as boolean)
    content = createObject("roSGNode", "ContentNode")
    
    createMenuItem(content, "channels", tr("Canais"))
    createMenuItem(content, "profile", tr("Perfil"))
    if shouldDisplayVod then createMenuItem(content, "vods", tr("Filmes e Séries"))
    
    m.menu.content = content
endfunction

function createMenuItem(content as dynamic, id as String, title as String)
    menuItem = content.createChild("ContentNode")
    menuItem.id = id
    menuItem.title = title
end function

function onButtonSelectedListener()
    print("Removing user from section.")
    deleteUserOnSection()
    print("Redirecting user to ProviderSelectionScene.")
    redirectScreenTo("ProviderSelectionScene")
end function

function itemSelectedListener()
    selectedItem = m.menu.content.getChild(m.menu.itemFocused)
    if selectedItem.id = "channels"
        redirectScreenTo("ChannelsScene")
    else if selectedItem.id = "vods"
        redirectScreenTo("VodsScene")
    end if
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"
end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            if getUserFromSection() = invalid
                return invalid
            end if
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

    m.logout.setFocus(true)
end function

function rowListChannelsListener()
    if m.rowListChannelsTask.content = invalid
        print "invalid rowListChannelsTask.content"
    else
        m.channelZoomRowList.content = m.rowListChannelsTask.content
        m.channelZoomRowList.visible = true
    end if
end function

function showExitDialog()
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "playerError"
    dialog.title = tr("Sair da aplicação")
    dialog.message = tr("Deseja sair da aplicação?")
    dialog.buttons = [tr("Sair"), tr("Cancelar")]
    dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
    dialog.observeField("wasClosed", "onDialogClose")
    showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        m.label = m.top.getParent().findNode("exitApp")
        m.label.setField("text", "close")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function shouldShowExitModel(key as string) as boolean
    return m.menu.hasFocus() and key = "back"
end function

function focusMenu()
    m.logout.setFocus(false)
    m.menu.setFocus(true)
end function

function shouldFocusMenu(key) as boolean
    return (key = "back" or key = "left") and m.logout.hasFocus()
end function

function onKeyEvent(key as string, press as boolean) as boolean
    print "in ProfileScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if shouldFocusMenu(key)
            focusMenu()
        else if shouldShowExitModel(key)
            showExitDialog()
        end if

        handled = true
    else
        if key = "right" and m.menu.hasFocus()
            m.logout.setFocus(true)
        end if
        handled = true
    end if
    return handled
end function
