import logging
import os
import re
import sys
import time

from bs4 import BeautifulSoup
from email_manager.gmail_api import (
    get_email_message_details,
    init_gmail_service,
    search_emails,
)
from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException
from selenium.webdriver import Remote
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait
from selenium_recaptcha_solver import RecaptchaSolver


def create_browser_window():
    test_ua = "Mozilla/5.0 (Windows NT 4.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36"
    options = webdriver.ChromeOptions()
    options.add_argument("--lang=pt-BR")
    options.add_argument(f"--user-agent={test_ua}")
    options.add_argument("--no-sandbox")
    options.add_argument("--disable-dev-shm-usage")
    options.add_argument("--window-size=1920,1080")

    browser = Remote(
        command_executor="http://chrome:4444/wd/hub",
        desired_capabilities={"browserName": "chrome"},
        options=options,
    )

    return browser


def login(driver, email, passw):
    try:
        driver.get("https://developer.roku.com/developer-channels/channels")
        time.sleep(10)
        email_input = driver.find_element(By.ID, "email")
        password_field = driver.find_element(By.ID, "password")

        email_input.send_keys(email)
        password_field.send_keys(passw)
        password_field.send_keys(Keys.RETURN)
    except Exception:
        logging.warning(f"Erro ao encontrar campos de email/senha...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    time.sleep(2)

    try:
        solver = RecaptchaSolver(driver=driver)
        recaptcha_iframe = driver.find_element(By.XPATH, '//iframe[@title="reCAPTCHA"]')
        solver.click_recaptcha_v2(iframe=recaptcha_iframe)
        password_field.send_keys(Keys.RETURN)
    except Exception:
        pass

    time.sleep(5)


def go_to_link_name(driver, link_name):
    logging.warning(f"Indo para {link_name}....")
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, link_name))
        )
        link.click()
        time.sleep(5)
    except Exception:
        logging.warning(f"Erro ao tentar ir para o canal {link_name}...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)


def upload_package(driver, file_path):
    logging.warning(f"Fazendo upload do pacote com caminho {file_path}....")

    try:
        button_email_xpath = "//button[@class='ks-button-component ks-button ks-button-link ks-button-large']/span[text()='Verificar e-mail da conta de pessoa desenvolvedora ']"
        button_device_xpath = "//button[@class='ks-button-component ks-button ks-button-link ks-button-large']/span[text()='Vincular um dispositivo à sua conta ']"

        button1 = driver.find_element("xpath", button_email_xpath)
        button2 = driver.find_element("xpath", button_device_xpath)

        if button1 or button2:
            logging.warning(
                f"Cliente nao possui uma conta ativar. Por favor, verifique a conta de email e vincule um dispositivo para realizar o processo de atualizacao novamente..."
            )
            try:
                driver.save_screenshot(
                    "/builds/desenvolvimento/cdntv-roku/screenshot.png"
                )
            except Exception as e:
                pass
            sys.exit(1)
    except Exception:
        pass

    try:
        upload_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.CSS_SELECTOR, "button[data-id='uploadBtn']"))
        )
        upload_button.click()
    except Exception:
        logging.warning(
            f"Botao fazer upload do novo pkg nao encontrado. Seguindo pipeline..."
        )

    time.sleep(5)
    try:
        file_input = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.ID, "inputArea"))
        )
        file_input.send_keys(file_path)
        time.sleep(5)
    except Exception:
        logging.warning(f"Erro ao enviar arquivo de pkg...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    try:
        button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (
                    By.XPATH,
                    "/html/body/div/div[2]/div[1]/main/div/div/div[3]/form/div[4]/div/button",
                )
            )
        )
        button.click()
    except Exception:
        logging.warning(f"Erro ao clicar em botao de enviar upload...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    try:
        time.sleep(5)

        cancel_publish = driver.find_elements(
            By.CSS_SELECTOR, "[data-id=confirm-cancel-publish-button]"
        )

        if len(cancel_publish) > 0:
            cancel_publish[0].click()

        try:
            button = WebDriverWait(driver, 30).until(
                EC.element_to_be_clickable(
                    (By.XPATH, "//button[text()='Rodar análise']")
                )
            )
            button.click()
        except Exception:
            pass

        time.sleep(10)

    except Exception:
        logging.warning(f"Erro ao encontrar campo para fazer upload do pkg...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)


def schedule_publication(driver):
    try:
        schedule_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.CSS_SELECTOR, "button[data-id='schedulePublishBtn']")
            )
        )
        schedule_button.click()
        time.sleep(2)
    except Exception:
        logging.warning(f"Erro ao clicar no botao de Agendar Publicacao...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    try:
        continuar_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (
                    By.XPATH,
                    "//button[contains(@class, 'ks-button-primary') and text()='Continuar']",
                )
            )
        )

        driver.execute_script("arguments[0].scrollIntoView(true);", continuar_button)
        driver.execute_script("arguments[0].click();", continuar_button)
        time.sleep(2)
    except Exception:
        logging.warning(
            f"Erro ao clicar no botao Continuar do Agendamento de Publicacao..."
        )
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    try:
        nota_textarea = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//textarea[@aria-label='Nota de lançamento']")
            )
        )
        driver.execute_script("arguments[0].scrollIntoView(true);", nota_textarea)
        nota_textarea.send_keys("Adição de novas features")
        time.sleep(2)

        checkbox1 = driver.find_element(By.XPATH, '//input[@name="terms1Consent"]')
        driver.execute_script("arguments[0].click();", checkbox1)
        time.sleep(2)

        checkbox2 = driver.find_element(By.XPATH, '//input[@name="terms2Consent"]')
        driver.execute_script("arguments[0].click();", checkbox2)
        time.sleep(2)
    except Exception:
        logging.warning(
            f"Erro ao preencher Nota de Lancamento e/ou checkboxes do Agendamento de Publicacao..."
        )
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)

    try:
        send_button = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.XPATH, "//button[@title='Enviar']"))
        )
        driver.execute_script("arguments[0].scrollIntoView(true);", send_button)
        send_button.click()

    except Exception:
        logging.warning(f"Erro ao enviar Agendamento de Publicacao...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)


def is_login_successful(driver):
    try:
        driver.find_element(By.CSS_SELECTOR, "[data-id='signout']")
        return True
    except:
        return False


def has_2fa_check(driver):
    h1_text = "Confirme que é você para concluir o login"
    try:
        h1_element = driver.find_element(By.XPATH, f"//h1[text()='{h1_text}']")

        if h1_element:
            return True
    except Exception:
        return False

    return False


def get_activation_code(email):
    codes = []
    client_file = "client_secret.json"
    service = init_gmail_service(client_file)

    query = f"from:('Roku' via) to:('{email}') subject:(Tentando fazer login?)"
    email_messages = search_emails(service, query, max_results=5)

    for message in email_messages:
        detail = get_email_message_details(service, message["id"])
        soup = BeautifulSoup(detail["body"], features="html.parser")

        element = soup.find("table").find_all("p")
        for i in element:
            fa2_code = re.search(r"(\d\d\d\d\d\d)", i.text)
            if fa2_code:
                codes.append(fa2_code.group(0))
                logging.warning(fa2_code.group(0))

    return codes


def input_2fa_code(driver, code):
    try:
        time.sleep(2)
        input_element = driver.find_element(By.ID, "code-id")
        input_element.send_keys(code)

        time.sleep(2)
        button = driver.find_element(
            By.XPATH,
            "//button[contains(@class, 'MuiButton-containedPrimary') and text()='Continuar']",
        )
        button.click()

        time.sleep(2)
        try:
            p_element = driver.find_element(
                By.XPATH,
                "//p[contains(@class, 'MuiFormHelperText-root') and contains(@class, 'Mui-error') and text()='O código inserido está incorreto. Verifique o código e tente novamente.']",
            )
            return False
        except NoSuchElementException:
            return True

    except Exception:
        logging.warning(f"Erro ao confirmar codigo de autenticacao de 2 fatores...")
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        sys.exit(1)


def main():
    channel_name = os.getenv("CHANNEL_NAME")
    email = os.getenv("EMAIL_CONFIRMATION_RECIPIENT")
    passw = os.getenv("EMAIL_PASSWORD")

    file_path = "/builds/desenvolvimento/cdntv-roku/pipeline/new.pkg"

    logging.warning("Criando janela do navegador....")
    driver = create_browser_window()

    logging.warning("Fazendo login na conta do cliente....")
    login(driver=driver, email=email, passw=passw)

    time.sleep(10)

    logging.warning("Checando autenticacao de 2 fatores...")
    if has_2fa_check(driver):
        codes = get_activation_code(email)
        logging.warning(f"Codes={codes}...")
        for code in codes:
            if input_2fa_code(driver, code):
                break

    time.sleep(5)

    if is_login_successful(driver):
        time.sleep(10)
        logging.warning(f"Tentando encontrar canal com nome {channel_name}....")
        elementos = driver.find_elements(
            By.CSS_SELECTOR,
            ".rdtable-datagrid-scrollview.rdtable-scrollview-novirtualize > .rdtable-datagrid-row",
        )
        child_element = driver.find_elements(
            By.CSS_SELECTOR,
            ".rdtable-datagrid-scrollview.rdtable-scrollview-novirtualize > .rdtable-datagrid-row [data-id='channelNameCell']",
        )

        nomes = [name.text for name in child_element]
        logging.warning(nomes)
        logging.warning(channel_name)

        if channel_name in nomes:
            index = nomes.index(channel_name)
            elementos[index].click()
        else:
            driver.quit()
            logging.warning(
                f"Canal com nome {channel_name} não foi encontrado. Por favor, verifique o nome do app sendo atualizado ...."
            )
            try:
                driver.save_screenshot(
                    "/builds/desenvolvimento/cdntv-roku/screenshot.png"
                )
            except Exception as e:
                pass
            sys.exit(1)

        go_to_link_name(driver, "Pacote do canal")
        time.sleep(5)
        upload_package(driver, file_path=file_path)
        time.sleep(30)
        go_to_link_name(driver, channel_name)

        schedule_publication(driver)

        time.sleep(5)

        logging.warning("Publicacao do canal agendada com sucesso....")
        driver.quit()

    else:
        try:
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        except Exception as e:
            pass
        logging.warning("Google detectou envio de captcha automatico...")
        logging.warning("Tentando novamente em 1 minuto...")
        time.sleep(60)
        driver.quit()
        main()


if __name__ == "__main__":
    main()
