import logging
import os
import sys
import time
import requests
from fastapi import FastAPI, HTTPException
import urllib

app = FastAPI()

ROKU_IP = os.getenv("ROKU_IP", "10.20.1.201")

def send_request(url):
    try:
        response = requests.post(url)
        if response.status_code != 200:
            logging.warning('status_code')
            logging.warning(response.status_code)
            raise HTTPException(status_code=response.status_code, detail="Failed request")
        time.sleep(0.3)
    except requests.exceptions.RequestException as e:
        logging.warning(f"Request failed: {e}")
        raise HTTPException(status_code=500, detail="Request failed")


def insert_text(url, texto: str):
    for caracter in texto:
        caracter = urllib.parse.quote_plus(caracter)
        send_request(f"{url}LIT_{caracter}")


# @app.post("/up")
# def down():
#     url = f"http://{ROKU_IP}:8060/keypress/Up"
#     send_request(url)
#     return {"message": "Up command sent successfully"}

@app.post("/down")
def down():
    url = f"http://{ROKU_IP}:8060/keypress/Down"
    send_request(url)
    return {"message": "Down command sent successfully"}

@app.post("/back")
def back():
    url = f"http://{ROKU_IP}:8060/keypress/Back"
    send_request(url)
    return {"message": "Back command sent successfully"}

@app.post("/home")
def home():
    url = f"http://{ROKU_IP}:8060/keypress/Home"
    send_request(url)
    return {"message": "Home command sent successfully"}

@app.post("/left")
def left():
    url = f"http://{ROKU_IP}:8060/keypress/Left"
    send_request(url)
    return {"message": "Left command sent successfully"}

@app.post("/rev")
def rev():
    url = f"http://{ROKU_IP}:8060/keypress/Rev"
    send_request(url)
    return {"message": "Rev command sent successfully"}

@app.post("/select")
def select():
    url = f"http://{ROKU_IP}:8060/keypress/Select"
    send_request(url)
    return {"message": "Select command sent successfully"}

@app.post("/select_language")
def select_language():
    url = f"http://{ROKU_IP}:8060/keypress/"
    time.sleep(3)
    send_request(f"{url}Left")
    send_request(f"{url}Up")
    send_request(f"{url}Select")
    return {"message": "Language selected"}

@app.post("/choose_screen_type")
def choose_screen_type():
    url = f"http://{ROKU_IP}:8060/keypress/"
    send_request(f"{url}Down")
    time.sleep(2)
    send_request(f"{url}Select")
    return {"message": "Choosed Screen Type"}

@app.post("/network")
def network():
    url = f"http://{ROKU_IP}:8060/keypress/"
    send_request(f"{url}Select")
    return {"message": "Network atualizar selected"}

@app.post("/make_login")
def make_login(email):
    url = f"http://{ROKU_IP}:8060/keypress/"
    send_request(f"{url}Select")
    insert_text(url, email)
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Select")
    return {"message": "Email entered"}


@app.post("/go_reset_screen")
def reset_roku():
    url = f"http://{ROKU_IP}:8060/keypress/"

    for _ in range(2):
        send_request(f"{url}Home")
        time.sleep(3)

    for _ in range(3):
        send_request(f"{url}UP")
        send_request(f"{url}Right")

    send_request(f"{url}Select")


@app.post("/reset_roku")
def reset_roku(number):
    url = f"http://{ROKU_IP}:8060/keypress/"

    # for i in number:
    #     insert_text(f"{url}LIT_{i}")
    insert_text(url, number)
    send_request(f"{url}Select")
    send_request(f"{url}Select")


@app.post("/accept_dev")
def accept_dev():
    url = f"http://{ROKU_IP}:8060/keypress/"

    send_request(f"{url}Select")
    time.sleep(0.5)
    send_request(f"{url}Up")
    time.sleep(0.5)
    send_request(f"{url}Select")
    time.sleep(3)
    send_request(f"{url}Select")
    send_request(f"{url}Select")
    insert_text(url, "cdn4")
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Down")
    send_request(f"{url}Select")







# import logging
# import os
# import sys
# import requests
# import time
# import xml.etree.ElementTree as ET



# # def is_roku_ultra(ip):
# #     url = f"http://{ip}:8060/query/device-info"

# #     try:
# #         response = requests.get(url)
# #         response.raise_for_status()
# #         root = ET.fromstring(response.content)

# #         model_name = root.find("model-name").text

# #         return model_name == "Roku Ultra"
# #     except requests.exceptions.RequestException as e:
# #         print("Erro na requisição:", e)
# #         exit(1)
# #     except ET.ParseError as e:
# #         print("Erro ao parsear o XML:", e)
# #         exit(1)




# def start_roku_ultra(ip):
#     url = f"http://{ip}:8060/keypress/"

#     time.sleep(3)
#     send_request(f"{url}Left")
#     send_request(f"{url}Up")
#     send_request(f"{url}Select")

