import logging
import os
import sys
import time

import requests
from skimage.metrics import structural_similarity as ssim
import cv2


def _call_remote_control_api(action):
    url = f"http://api.remote.roku.cdnsystem.cloud/{action}"

    payload = {}
    headers = {}

    response = requests.request("POST", url, headers=headers, data=payload)

    logging.warning(response.text)


def find_available_camera(max_index=10):
    for index in range(max_index):
        cap = cv2.VideoCapture(index)
        if cap.isOpened():
            print(f"Camera found at index {index}")
            return cap
        else:
            print(f"No camera at index {index}")
            cap.release()
    return None


def capturar_e_comparar(
    file_name, reference_image, dimension_a, dimension_b, dimension_c, dimension_d
):
    logging.warning("capturar_e_comparar")
    cap = find_available_camera()
    _call_remote_control_api("left")

    name = "reference_image.png"
    attemps = 0
    while True:
        ret, frame = cap.read()
        if not ret:
            logging.warning("Erro ao capturar o frame")
            cap.release()
            exit(1)

        gray_frame = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)

        area_to_compare = gray_frame[dimension_a:dimension_b, dimension_c:dimension_d]
        cv2.imwrite(name, area_to_compare)
        upload_image(name)

        similarity, _ = ssim(reference_image, area_to_compare, full=True)
        logging.warning(f"Similarity: {similarity}")

        if similarity > 0.9:
            logging.warning("Matching Area Found...")
            cap.release()
            exit(0)
        elif file_name == "languageReaderMessage_430_460_30_240" and attemps == 10:
            logging.warning("Trying to change option")
            _call_remote_control_api("back")
            _call_remote_control_api("down")
            attemps = 0

        attemps += 1
        time.sleep(2)


def upload_image(file_path, url="http://10.20.1.52:8000/upload-image"):
    with open(file_path, "rb") as image_file:
        files = {"file": (file_path, image_file, "image/png")}
        response = requests.post(url, files=files)
        if response.status_code == 200:
            logging.warning("Imagem enviada com sucesso!")
        else:
            logging.warning(f"Erro ao enviar imagem: {response.status_code}")


def get_dimensions(file_name):
    logging.warning("file_name")
    parts = file_name.split("_")

    if len(parts) != 5:
        print("Wrong format file name")
        exit(1)

    return int(parts[1]), int(parts[2]), int(parts[3]), int(parts[4])


if __name__ == "__main__":
    try:
        if len(sys.argv) > 1:
            file_name = sys.argv[1]
            reference_image = cv2.imread(
                f"/app/images/{file_name}.png", cv2.IMREAD_GRAYSCALE
            )

            d_a, d_b, d_c, d_d = get_dimensions(file_name)

            capturar_e_comparar(file_name, reference_image, d_a, d_b, d_c, d_d)
        else:
            print("No image parameter")
            exit(1)
    except Exception as e:
        logging.warning("Error main")
        logging.warning(e)
        exit(1)
