sub init()
    m.top.functionName = "getVodsCategoriesResponse"
end sub

function ResponseDTO(data, status, statusCode, msg, hasError) as object
    return {
        data: data,
        status: status,
        statusCode: statusCode,
        msg: msg,
        hasError: hasError
    }

end function

function isResponseInvalid(code as integer, res as string) as boolean
    return (code = 200 and res = "") or (code <> 200) or res = "[]"
end function

sub getVodsCategoriesResponse() as object
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)
    request.SetUrl("https://" + m.top.providerURL + "/vod/categories/" + m.top.email + "/1?t=" + m.top.token)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            res = msg.GetString()

            if isResponseInvalid(code, res)
                response = ResponseDTO("", "Unexpected", code, "Não foi possível carregar os VODS!", true)
                m.top.VODCategoriesListDTO = response
                return invalid
            end if

            VODCategoriesListDTO = CreateObject("roArray", 10, true)
            VODCategoriesResponse = ParseJSON(res)

            for each VODCategory in VODCategoriesResponse
                VODCategoryDTO = VODCategoriesResponseMapper(VODCategory)

                for each vod in VODCategory.vods
                    vodDTO = vodDTOMapper(vod)
                    if vodDTO.selling = false then VODCategoryDTO.vods.push(vodDTO)
                end for

                if VODCategoryDTO.vods.count() > 0 then VODCategoriesListDTO.push(vodCategoryDTO)

            end for

            response = ResponseDTO(VODCategoriesListDTO, "Success", code, "VODs carregados com sucesso!", false)
            m.top.VODCategoriesListDTO = response

        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end sub

function VODCategoriesResponseMapper(response) as object
    return {
        title: response.title,
        theme: response.theme,
        vods: []
    }
end function

function vodDTOMapper(response) as object
    time = response?.time
    if time = invalid
        time = "0"
    end if

    return {
        name: response.name,
        portugueseTitle: response.portugueseTitle,
        selling: response.selling,
        poster: "https://" + m.top.providerURL + "/images/" + response.name,
        time: time.ToInt()
    }
end function
