function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    m.mainLogo = m.top.findNode("mainLogo")
    m.mainLogo.uri = "https://" + m.providerURL + "/logo/main-logo.png_150_150"
    m.resendCountDown = 60
    m.menu = m.top.findNode("menu")
    m.title = m.top.findNode("title")
    m.title.text = tr("Filmes e Séries")
    m.channels = m.top.findNode("channels")
    m.channels.text = tr("Canais")
    m.vod = m.top.findNode("vod")
    m.vod.text = tr("Filmes")
    m.profile = m.top.findNode("profile")
    m.profile.text = tr("Perfil")
    m.search = m.top.findNode("search")
    m.search.text = tr("Pesquisar")
    m.menu.observeField("itemSelected", "itemSelectedListener")
    setComponentStyles()
    loadRefreshToken()
    isEmailConfirmed()

end function

function setComponentStyles()
    m.subtitle = m.top.findNode("subtitle")
    m.subtitle.drawingStyles = {
        "Bold": {
            "fontUri": "font:SmallBoldSystemFont"
        }
        "default": {
            "fontUri": "font:SmallSystemFont"
        }
    }
    m.subtitle.text = tr("Pressione Voltar para acessar o menu")
end function

function isEmailConfirmed()
    m.isEmailConfirmedTask = m.top.findNode("isEmailConfirmedTask")
    m.isEmailConfirmedTask.providerURL = m.providerURL
    m.isEmailConfirmedTask.token = m.user.token
    m.isEmailConfirmedTask.control = "RUN"
    m.isEmailConfirmedTask.observeField("isEmailConfirmedResponseDTO", "isEmailConfirmedResponseDTOListener")
end function

function isEmailConfirmedResponseDTOListener()
    loadVODs()
    m.vodZoomRowList = m.top.findNode("vodZoomRowList")
    m.vodZoomRowList.observeField("rowSelected", "itemSelected")
    m.top.visible = true
end function

function removeSearchOption()
    searchNode = m.menu.content.findNode("search")
    m.menu.content.removeChild(searchNode)
end function

function onModalClose()
    m.menu.setFocus(true)
end function

function emailConfirmationDialogOnSelected()

    m.confirmEmailTask = m.top.findNode("ConfirmEmailTask")
    m.confirmEmailTask.providerURL = m.providerURL
    m.confirmEmailTask.token = m.user.token
    m.confirmEmailTask.email = m.emailConfirmationDialog.text
    m.confirmEmailTask.control = "RUN"
    m.confirmEmailTask.observeField("confirmEmailResponseDTO", "confirmEmailListener")
end function

function confirmEmailListener()
    if m.confirmEmailTask.confirmEmailResponseDTO = invalid then return invalid

    response = ParseJSON(m.confirmEmailTask.confirmEmailResponseDTO)

    if not response.data.isSent then return invalid

    resendCountDown()

end function

function resendCountDown()
    m.timer = CreateObject("roSGNode", "Timer")
    m.timer.id = "timeRefresh"
    m.timer.repeat = true
    m.timer.duration = 1
    m.timer.control = "start"
    m.timer.ObserveField("fire", "timeListener")
end function

function timeListener()
    m.resendCountDown--

    if m.resendCountDown >= 0
        m.remainingCountDownText = tr("Aguarde") + " (" + Str(m.resendCountDown) + " )"
    else
        m.timer.control = "stop"
        m.remainingCountDownText = "Enviar e-mail"
        m.emailConfirmationDialog.setFocus(true)
        m.resendCountDown = 60
    end if

    m.emailConfirmationDialog.buttons = [m.remainingCountDownText]

end function

function itemSelectedListener()
    selectedItem = m.menu.content.getChild(m.menu.itemFocused)
    if selectedItem.id = "profile"
        redirectScreenTo("ProfileScene")
    else if selectedItem.id = "channels"
        redirectScreenTo("ChannelsScene")
    else if selectedItem.id = "search"
        redirectScreenTo("VodSearchScene")
    end if
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"

end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

end function

function loadVODs()
    m.VODsTask = m.top.findNode("VODsTask")
    m.VODsTask.token = m.user.token
    m.VODsTask.email = m.user.email
    m.VODsTask.username = m.user.username
    m.VODsTask.providerURL = m.providerURL
    m.VODsTask.control = "RUN"
    m.VODsTask.observeField("VODCategoriesListDTO", "VODsOnLoad")

end function

function VODsOnLoad()

    if m.VODsTask.VODCategoriesListDTO.hasError
        print m.VODsTask.VODCategoriesListDTO
        dialog = createObject("roSGNode", "Dialog")
        dialog.id = "playerError"
        dialog.title = tr("Erro ao carregar conteúdo")
        dialog.message = tr("Não foi possível carregar os conteúdos, tente novamente mais tarde.")
        dialog.buttons = [tr("Tentar novamente"), tr("Cancelar")]
        dialog.observeField("buttonSelected", "buttonSelectedOnDialog")
        dialog.observeField("wasClosed", "onDialogClose")
        showDialog(dialog)
    else
        loadRowListVods()
    end if

end function

function onDialogClose()
    m.menu.setFocus(true)
end function

function buttonSelectedOnDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        redirectScreenTo("VodsScene")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function loadRowListVods()
    m.VODCategoriesListDTO = m.VODsTask.VODCategoriesListDTO.data
    m.RowListVODsTask = createObject("roSGNode", "RowListVODsTask")
    m.RowListVODsTask.VODCategoriesListDTO = m.VODCategoriesListDTO
    m.RowListVODsTask.observeField("content", "RowListVODsListener")
    m.RowListVODsTask.control = "RUN"

    m.vodZoomRowList.visible = false
    m.vodZoomRowList.setFocus(true)

end function

function RowListVODsListener() as dynamic
    if m.RowListVODsTask.content = invalid then return invalid

    m.vodZoomRowList.content = m.RowListVODsTask.content
    m.vodZoomRowList.visible = true

    if existingLastSelectedVOD() then
        m.vodZoomRowList.jumpToRowItem = getNodePositionByVodID(m.global.lastSelectedVOD)
    end if

end function

function existingLastSelectedVOD()
    return m.global.lastSelectedVOD <> invalid and m.global.lastSelectedVOD <> ""
end function

function getNodePositionByVodID(vod_id)
    row_index = 0
    while row_index < m.vodZoomRowList.content.getChildCount()
        row_children = m.vodZoomRowList.content.getChild(row_index)
        row_children_index = 0
        while row_children_index < row_children.getChildCount()
            vod_node = row_children.getChild(row_children_index)
            if vod_node.vod_id = vod_id then return [row_index, row_children_index]
            row_children_index = row_children_index + 1
        end while
        row_index = row_index + 1
    end while

    return [0, 0]
end function

function itemSelected()
    row = m.vodZoomRowList.content.getChild(m.vodZoomRowList.rowItemSelected[0])
    selectedVODNode = row.getChild(m.vodZoomRowList.rowItemSelected[1])
    selectedVOD = selectedVODNode.id
    setVodName(ParseJson(selectedVOD).name)
    setCurrentVODOnSection(selectedVOD)
    redirectScreenTo("VodInternalScene")
end function

function setCurrentVODOnSection(vod)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("currentVOD", vod)
    section.Flush()
end function

function showExitDialog()
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "playerError"
    dialog.title = tr("Sair da aplicação")
    dialog.message = tr("Deseja sair da aplicação?")
    dialog.buttons = [tr("Sair"), tr("Cancelar")]
    dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
    dialog.observeField("wasClosed", "onDialogClose")
    showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        m.label = m.top.getParent().findNode("exitApp")
        m.label.setField("text", "close")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function shouldFocusMenuExistingRowList(key as string) as boolean
    if m.vodZoomRowList = invalid then return false
    return (key = "back" or key = "left") and m.vodZoomRowList.hasFocus()
end function

function shouldFocusRowListExistingRowList(key as string) as boolean
    if m.vodZoomRowList = invalid then return false
    return key = "right" and m.menu.hasFocus()
end function

function shouldShowExitModel(key as string) as boolean
    return m.menu.hasFocus() and key = "back"
end function

function onKeyEvent(key as string, press as boolean) as boolean
    print "in ChannelScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if shouldFocusMenuExistingRowList(key)
            m.vodZoomRowList.setFocus(false)
            m.menu.setFocus(true)
        else if shouldShowExitModel(key)
            showExitDialog()
        end if
        handled = true
    else
        if shouldFocusRowListExistingRowList(key)
            m.vodZoomRowList.setFocus(true)
        end if
        handled = true
    end if
    return handled
end function
