import json
import logging
import re
import telnetlib
import os
import time

import requests
from functions import call_remote_control_api, capturar_e_comparar, converter_para_squashfs, enviar_instalar_roku, fazer_package, get_logo, get_number, get_all_images_frame

PKG_PATH = os.getenv('PKG_PATH', '')
ZIP_FILE_PATH = os.getenv('ZIP_FILE_PATH', '')
IP_ROKU = os.getenv('ROKU_IP', '')
MANAGER_URL = 'http://' + os.getenv("MANAGERURL", '')


def action(screen, cap, attemps):
    if screen is None:
        logging.warning('No screen matches')
    elif attemps > 120:
        call_remote_control_api('home')
    elif screen in ['telaInicial']:
        create_channel()

        attemps = 0
    else:
        logging.warning('screen')
        logging.warning(screen)
        cap.release()
        exit(1)

    # cap.release() TODO: Adicionar quando for encerrar o script
    return attemps


def gerar_genkey_rokutelnet():
    try:
        with telnetlib.Telnet(IP_ROKU, 8080, timeout=11) as tn:
            tn.write(b'genkey\n')
            time.sleep(10)
            return tn.read_very_eager().decode('utf-8').strip()
    except Exception as e:
        logging.warning(f"Erro ao conectar ao Roku: {e}")
        return None


def create_channel():
    pkg_pass = ''
    dev_id = ''

    roku_gen_key_response = gerar_genkey_rokutelnet()
    time.sleep(15)

    if roku_gen_key_response is None:
        logging.warning("Erro: roku_gen_key_response é None.")
        exit(1)
    elif match := re.search(r'Password:\s*(\S+)', roku_gen_key_response):
        if match := re.search(
            r"Password:\s*(\S+)\s*DevID:\s*(\S+)", roku_gen_key_response
        ):
            pkg_pass = match[1]
            dev_id = match[2]
            logging.warning(f"Password: {pkg_pass}")
            logging.warning(f"DevID: {dev_id}")
        else:
            logging.warning("Não foi possível encontrar o Password e o DevID.")
            exit(1)
    else:
        logging.warning("Erro: Padrão de senha não encontrado.")
        logging.warning(roku_gen_key_response)
        exit(1)

    logging.warning('Get logo')
    get_logo(MANAGER_URL)
    logging.warning('Enviar instalar no Roku')
    enviar_instalar_roku(IP_ROKU, ZIP_FILE_PATH)
    logging.warning('Converter para squashfs')
    converter_para_squashfs(IP_ROKU, ZIP_FILE_PATH)

    logging.warning('Fazer package')
    fazer_package(IP_ROKU, pkg_pass)

    _save_data_on_central(pkg_pass, dev_id)

    logging.warning('Tela de reset')
    call_remote_control_api('go_reset_screen')

    exit(0)

def _save_data_on_central(pkg_pass, dev_id):
    url = "https://central.technobox.com.br/api/app/1913/roku"

    data = {
        "rokuPkgPassword": pkg_pass,
        "rokuDevId": dev_id
    }

    payload = json.dumps(data)
    headers = {
        'Content-Type': 'application/json'
    }

    response = requests.request("POST", url, headers=headers, data=payload)

    logging.warning("Data saved on central")
    logging.warning(data)
    logging.warning(response.status_code)
    if response.status_code != 200:
        logging.warning("Error on save data on Central")
        exit(1)

if __name__ == "__main__":
    try:
        images_data_list = get_all_images_frame()
        capturar_e_comparar(images_data_list, action)
    except Exception as e:
        logging.warning('Error')
        logging.warning(e)
        exit(1)
