import logging
import os
import time

import requests
from pathlib import Path

from functions import call_remote_control_api, capturar_e_comparar, converter_para_squashfs, enviar_instalar_roku, fazer_package, get_number, get_all_images_frame, get_logo

class RaisedException(Exception):
    pass

PKG_PATH = os.getenv('PKG_PATH', '')
ZIP_FILE_PATH = os.getenv('ZIP_FILE_PATH', '')
IP_ROKU = os.getenv('ROKU_IP', '')
MANAGER_URL = 'http://' + os.getenv("MANAGERURL", '')


def _get_latest_pkg_error(e):
    logging.warning("Erro ao pegar o ultimo PKG: ")
    logging.warning(e)
    logging.warning(f"Tentando novamente: {PKG_PATH}")
    time.sleep(3)


def get_latest_pkg():
    founded = False

    while not founded:
        try:
            my_file_path = Path(PKG_PATH)
            if my_file_path.is_file():
                founded = True
            else:
                _get_latest_pkg_error('')
        except Exception as e:
            _get_latest_pkg_error(e)


def rekey():
    url = f"http://{IP_ROKU}/plugin_inspect"

    pkg_password = os.getenv('PKG_PASSWORD', '')
    payload = {
            'passwd': pkg_password,
            'mysubmit': 'Rekey'
        }
    files=[
            ('archive',(PKG_PATH, open(PKG_PATH, 'rb'), 'application/octet-stream'))
        ]
    headers = {
        'Authorization': 'Digest username="rokudev", realm="rokudev", nonce="1742319920", uri="/plugin_inspect", response="75c546661e23277dd026c0eb24fffbe3", qop=auth, nc=00000042, cnonce="c2eb85ca7a9d778c"'
    }

    response = requests.request("POST", url, headers=headers, data=payload, files=files)

    logging.warning(f"Rekey: {response.status_code}")
    if response.status_code != 200:
        logging.warning("Error on rekey")
        exit(1)


def action(screen, cap, attemps):
    if screen is None:
        logging.warning('No screen matches')
    elif screen in ['telaInicial']:
        build_channel()

        attemps = 0
    else:
        logging.warning('screen')
        logging.warning(screen)
        cap.release()
        exit(1)

    # cap.release() TODO: Adicionar quando for encerrar o script
    return attemps


def build_channel():
    logging.warning('Get logo')
    get_logo(MANAGER_URL)
    logging.warning('Enviar instalar no Roku')
    enviar_instalar_roku(IP_ROKU, ZIP_FILE_PATH)
    logging.warning('Converter para squashfs')
    converter_para_squashfs(IP_ROKU, ZIP_FILE_PATH)

    logging.warning('Pegar ultimo pkg')
    get_latest_pkg()

    logging.warning('REKEY')
    rekey()
    logging.warning('SLEEP 10')
    time.sleep(10)

    logging.warning('Fazer package')
    pkg_password = os.getenv('PKG_PASSWORD', '')
    fazer_package(IP_ROKU, pkg_password)

    exit(0)

if __name__ == "__main__":
    try:
        images_data_list = get_all_images_frame()
        capturar_e_comparar(images_data_list, action)
    except Exception as e:
        logging.warning('Error')
        logging.warning(e)
        exit(1)
