import logging
import os
import re
import sys
import time

from bs4 import BeautifulSoup
from email_manager.gmail_api import (
    get_email_message_details,
    init_gmail_service,
    search_emails,
)
from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException
from selenium.webdriver import Remote
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.chrome.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.common.keys import Keys
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait
from selenium_recaptcha_solver import RecaptchaSolver
from webdriver_manager.chrome import ChromeDriverManager


def create_browser_window():
    test_ua = "Mozilla/5.0 (Windows NT 4.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/130.0.0.0 Safari/537.36"
    options = webdriver.ChromeOptions()
    options.add_argument("--lang=pt-BR")
    options.add_argument(f"--user-agent={test_ua}")
    options.add_argument("--no-sandbox")
    options.add_argument("--disable-dev-shm-usage")
    options.add_argument("--window-size=1920,1080")

    browser = Remote(
        command_executor="http://chrome:4444/wd/hub",
        desired_capabilities={"browserName": "chrome"},
        options=options,
    )

    return browser


def login(driver, email, passw):
    try:
        driver.get("https://developer.roku.com/developer-channels/channels")
        time.sleep(10)
        email_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "email"))
        )
        password_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "password"))
        )

        email_input.send_keys(email)
        password_field.send_keys(passw)
        password_field.send_keys(Keys.RETURN)

        time.sleep(5)
    except Exception:
        logging.warning(f"Erro ao encontrar campos de email/senha...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)

    try:
        solver = RecaptchaSolver(driver=driver)
        recaptcha_iframe = driver.find_element(By.XPATH, '//iframe[@title="reCAPTCHA"]')
        solver.click_recaptcha_v2(iframe=recaptcha_iframe)
    except:
        pass


    password_field.send_keys(Keys.RETURN)

    time.sleep(5)


def create_channel(driver, channel_name):
    try:
        create_channel_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.CSS_SELECTOR, '[data-id="createChannelBtn"]')
            )
        )
        create_channel_button.click()
        time.sleep(3)

        channel_name_input = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.ID, "channelName"))
        )
        channel_name_input.send_keys(channel_name)
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "channelStoreCountries"))
        )
        country_input.send_keys("Brazil")
        time.sleep(3)
        country_input.send_keys(Keys.ENTER)

        time.sleep(3)
        language_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "defaultLanguage"))
        )
        language_input.send_keys("Português")
        time.sleep(3)
        language_input.send_keys(Keys.ENTER)
        time.sleep(3)

        create_channel_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Criar canal' and text()='Criar canal']")
            )
        )
        create_channel_button.click()
    except Exception:
        logging.warning(f"Erro ao criar canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_channel_properties(driver):
    try:
        current_url = driver.current_url

        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Configuração de listagem"))
        )
        link.click()

        time.sleep(5)
        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "exclusionChannelStoreCode"))
        )
        country_input.send_keys("Brazil")
        time.sleep(3)
        country_input.send_keys(Keys.ENTER)

        span_sim = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    "//input[@id='directedAtChildren-yes']/following-sibling::span[text()='Sim']",
                )
            )
        )
        driver.execute_script("arguments[0].click();", span_sim)
        time.sleep(5)

        time.sleep(5)
        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "descriptiveCategoryId"))
        )
        country_input.send_keys("Live TV")
        time.sleep(3)
        country_input.send_keys(Keys.ENTER)

        time.sleep(5)
        span_todas_idades = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    "//input[@id='parentalHint-AllAges']/following-sibling::span/span[text()='Todas as idades - Apropriado para todos os públicos']",
                )
            )
        )
        driver.execute_script("arguments[0].click();", span_todas_idades)

        time.sleep(5)
        save_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Salvar' and not(@disabled)]")
            )
        )
        save_button.click()

        return current_url
    except Exception:
        logging.warning(f"Erro ao configurar propriedades do canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_store_assets(driver, logo_path, banner_path):
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Ativos da loja"))
        )
        link.click()

        time.sleep(5)

        poster_upload_div = driver.find_element(
            By.CSS_SELECTOR, 'div[data-id="posterUploadInput"]'
        )
        file_input = poster_upload_div.find_element(
            By.CSS_SELECTOR, 'input[type="file"]'
        )
        file_input.send_keys(logo_path)

        time.sleep(5)

        poster_upload_div = driver.find_element(
            By.CSS_SELECTOR, 'div[data-id="screenshotUploadInput"]'
        )
        file_input = poster_upload_div.find_element(
            By.CSS_SELECTOR, 'input[type="file"]'
        )
        file_input.send_keys(banner_path)

        time.sleep(5)

        save_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Salvar Português']")
            )
        )
        save_button.click()
        time.sleep(5)
    except Exception:
        logging.warning(f"Erro ao configurar os ativos da loja...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_channel_profile(driver):
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Perfil do canal"))
        )
        link.click()
        time.sleep(5)

        developerPrivacyUrl = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "developerPrivacyUrl"))
        )
        developerPrivacyUrl.send_keys(
            "https://apprelease.cdn.tv.br/apks/apprelease.cdn.tv.br/"
        )
        time.sleep(3)

        termsOfUseUrl = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "termsOfUseUrl"))
        )
        termsOfUseUrl.send_keys(
            "https://apprelease.cdn.tv.br/apks/apprelease.cdn.tv.br/"
        )

        span = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    "//input[@id='canCreateUserAccount-yes']/following-sibling::span[text()='Sim']",
                )
            )
        )

        driver.execute_script("arguments[0].click();", span)
        time.sleep(5)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "supportContactEmail"))
        )
        country_input.send_keys("suporte@cdn.tv.br")

        time.sleep(5)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "informationUrl"))
        )
        country_input.send_keys(
            "https://apprelease.cdn.tv.br/apks/apprelease.cdn.tv.br/"
        )

        time.sleep(5)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "adminContactName"))
        )
        country_input.send_keys("suporte")
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "adminContactPhone"))
        )
        country_input.send_keys("555133929584")
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "adminContactEmail"))
        )
        country_input.send_keys("suporte@cdn.tv.br")
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "techContactName"))
        )
        country_input.send_keys("suporte")
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "techContactPhone"))
        )
        country_input.send_keys("555133929584")
        time.sleep(3)

        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "techContactEmail"))
        )
        country_input.send_keys("suporte@cdn.tv.br")

        time.sleep(5)
        save_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Salvar' and not(@disabled)]")
            )
        )
        save_button.click()

    except Exception:
        logging.warning(f"Erro ao configurar o perfil do canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_monetization(driver):
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Configuração da monetização"))
        )
        link.click()

        span = driver.find_element(
            By.XPATH,
            '//label[@class="roku-form-components-boolean-label"]/span[@class="roku-form-components-boolean-default-text" and text()="Não vou monetizar meu canal."]',
        )
        if span.is_displayed():
            span.click()

        time.sleep(5)

        save_button = driver.find_element(
            By.XPATH, "/html/body/div/div[2]/div[1]/main/div/div/div[4]/div/button[2]"
        )
        save_button.click()

    except Exception:
        logging.warning(f"Erro ao configurar a monetizacao do canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_channel_package(driver, file_path):
    try:
        button_email_xpath = "//button[@class='ks-button-component ks-button ks-button-link ks-button-large']/span[text()='Verificar e-mail da conta de pessoa desenvolvedora ']"
        button_device_xpath = "//button[@class='ks-button-component ks-button ks-button-link ks-button-large']/span[text()='Vincular um dispositivo à sua conta ']"

        button1 = driver.find_element("xpath", button_email_xpath)
        button2 = driver.find_element("xpath", button_device_xpath)

        if button1 or button2:
            logging.warning(
                f"Cliente nao possui uma conta ativar. Por favor, verifique a conta de email e vincule um dispositivo para realizar o processo de atualizacao novamente..."
            )
            driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
            sys.exit(1)
    except Exception:
        pass

    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Pacote do canal"))
        )
        link.click()

        time.sleep(3)
        file_input = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.ID, "inputArea"))
        )

        file_input.send_keys(file_path)

        time.sleep(5)
        country_input = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.ID, "minFirmwareVersionInput"))
        )
        country_input.send_keys("v11.0.0 b2")
        time.sleep(5)
        country_input.send_keys(Keys.DOWN)
        country_input.send_keys(Keys.ENTER)

        time.sleep(5)

        button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (
                    By.XPATH,
                    "/html/body/div/div[2]/div[1]/main/div/div/div[3]/form/div[4]/div/button",
                )
            )
        )

        button.click()

        button = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    '//button[contains(@class, "ks-button-component") and contains(text(), "Rodar análise")]',
                )
            )
        )

        time.sleep(5)
        if button.is_enabled():
            button.click()

        logging.warning("Esperando pela analise do pacote......")
        time.sleep(45)
        logging.warning("Analise do pacote realizada com sucesso......")

    except Exception:
        logging.warning(f"Erro ao configurar o pacote do canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_direct_link(driver):
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Link direto"))
        )
        link.click()

        time.sleep(3)

        button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[contains(text(), 'Adicionar links diretos')]")
            )
        )
        button.click()

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.NAME, "mediaType"))
        )
        input_field.send_keys("Movie")
        time.sleep(5)
        input_field.send_keys(Keys.ENTER)

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.NAME, "contentId"))
        )
        input_field.send_keys("sh_spider_woman")

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    "/html/body/div/div[2]/div[1]/main/div/div/div[6]/div/div/div[2]/div[2]/div/form/div[3]/input",
                )
            )
        )
        input_field.send_keys("Sherlock Holmes e a Mulher Aranha")
        time.sleep(3)

        span = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (
                    By.XPATH,
                    '//label[@class="roku-form-components-boolean-label"]/span[@class="roku-form-components-boolean-default-text" and text()="Validade indefinida"]',
                )
            )
        )
        if span.is_displayed():
            span.click()

        time.sleep(5)
        save_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Salvar' and not(@disabled)]")
            )
        )
        save_button.click()

    except Exception:
        logging.warning(f"Erro ao configurar link direto do canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def configure_test_credentials(driver):
    try:
        link = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.LINK_TEXT, "Credenciais de teste"))
        )
        link.click()

        time.sleep(3)

        button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (
                    By.XPATH,
                    "//button[contains(text(), 'Adicionar credencial de teste')]",
                )
            )
        )
        button.click()

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.NAME, "title"))
        )
        input_field.send_keys("roku")

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.NAME, "username"))
        )
        input_field.send_keys("roku")

        time.sleep(5)
        input_field = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.NAME, "password"))
        )
        input_field.send_keys("roku")

        time.sleep(5)

        checkbox = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.CSS_SELECTOR, "#modalDescription > div > form > div.Roku-Form-Stateless-Checkbox.roku-form-components-boolean.roku-form-element.roku-form-components-boolean-small.roku-default-form-layout.ks-mb-20.checkbox-indefinite > label > span:nth-child(2)"))
        )

        checkbox.click()

        time.sleep(5)

        save_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (By.XPATH, "//button[@title='Salvar' and not(@disabled)]")
            )
        )

        save_button.click()
    except Exception:
        logging.warning(f"Erro ao configurar credenciais de teste para o canal...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)

def schedule_publication(driver):
    try:
        time.sleep(5)
        WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.CSS_SELECTOR, "button[data-id='schedulePublishBtn']"))
        )

        driver.execute_script("document.querySelector(\"button[data-id='schedulePublishBtn']\").click();")

        time.sleep(5)

        continuar_button = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable(
                (
                    By.XPATH,
                    "//button[contains(@class, 'ks-button-primary') and text()='Continuar']",
                )
            )
        )

        driver.execute_script("arguments[0].scrollIntoView(true);", continuar_button)
        driver.execute_script("arguments[0].click();", continuar_button)

        nota_textarea = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located(
                (By.XPATH, "//textarea[@aria-label='Nota de lançamento']")
            )
        )
        driver.execute_script("arguments[0].scrollIntoView(true);", nota_textarea)
        nota_textarea.send_keys("Adição de novas features")

        checkbox1 = driver.find_element(By.XPATH, '//input[@name="terms1Consent"]')
        driver.execute_script("arguments[0].click();", checkbox1)

        checkbox2 = driver.find_element(By.XPATH, '//input[@name="terms2Consent"]')
        driver.execute_script("arguments[0].click();", checkbox2)

        send_button = WebDriverWait(driver, 10).until(
            EC.presence_of_element_located((By.XPATH, "//button[@title='Enviar']"))
        )
        driver.execute_script("arguments[0].scrollIntoView(true);", send_button)
        send_button.click()

    except Exception:
        logging.warning(f"Erro ao enviar pkg do canal para publicacao...")
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def is_login_successful(driver):
    try:
        driver.find_element(By.CSS_SELECTOR, "[data-id='signout']")
        return True
    except:
        return False


def has_2fa_check(driver):
    h1_text = "Confirme que é você para concluir o login"
    try:
        h1_element = driver.find_element(By.XPATH, f"//h1[text()='{h1_text}']")

        if h1_element:
            return True
    except Exception:
        return False

    return False


def get_activation_code(email):
    codes = []
    client_file = "client_secret.json"
    service = init_gmail_service(client_file)

    query = f"from:('Roku' via) to:('{email}') subject:(Tentando fazer login?)"
    email_messages = search_emails(service, query, max_results=5)

    for message in email_messages:
        detail = get_email_message_details(service, message["id"])
        soup = BeautifulSoup(detail["body"], features="html.parser")

        element = soup.find("table").find_all("p")
        for i in element:
            fa2_code = re.search(r"(\d\d\d\d\d\d)", i.text)
            if fa2_code:
                codes.append(fa2_code.group(0))
                logging.warning(fa2_code.group(0))

    return codes


def input_2fa_code(driver, code):
    try:
        time.sleep(5)
        input_element = driver.find_element(By.ID, "code-id")
        input_element.send_keys(code)

        time.sleep(5)
        button = driver.find_element(
            By.XPATH,
            "//button[contains(@class, 'MuiButton-containedPrimary') and text()='Continuar']",
        )
        button.click()

        time.sleep(5)
        try:
            p_element = driver.find_element(
                By.XPATH,
                "//p[contains(@class, 'MuiFormHelperText-root') and contains(@class, 'Mui-error') and text()='O código inserido está incorreto. Verifique o código e tente novamente.']",
            )
            return False
        except NoSuchElementException:
            return True

    except Exception:
        logging.warning(
            f"Erro ao tentar enviar o codigo de autenticacao de 2 fatores..."
        )
        driver.save_screenshot("/builds/desenvolvimento/cdntv-roku/screenshot.png")
        sys.exit(1)


def main():
    channel_name = os.getenv("CHANNEL_NAME")
    email = os.getenv("EMAIL_CONFIRMATION_RECIPIENT")
    passw = os.getenv("EMAIL_PASSWORD")

    file_path = "/builds/desenvolvimento/cdntv-roku/pipeline/new.pkg"
    banner_path = (
        "/builds/desenvolvimento/cdntv-roku/pipeline/roku_store/main-banner.png"
    )
    logo_path = "/builds/desenvolvimento/cdntv-roku/pipeline/main-logo.png"

    logging.warning("Criando janela do navegador....")
    driver = create_browser_window()

    logging.warning("Fazendo login na conta do cliente....")
    login(driver=driver, email=email, passw=passw)

    time.sleep(10)

    logging.warning("Checando código de autenticacao de 2 fatores...")
    if has_2fa_check(driver):
        codes = get_activation_code(email)
        logging.warning(f"Codes={codes}...")
        for code in codes:
            if input_2fa_code(driver, code):
                break

    time.sleep(5)

    if is_login_successful(driver):
        logging.warning(f"Fazendo criacao do canal de nome {channel_name}....")
        create_channel(driver=driver, channel_name=channel_name)
        time.sleep(5)
        url = driver.current_url

        time.sleep(5)
        logging.warning("Configurando as propriedades do canal....")
        configure_channel_properties(driver=driver)

        time.sleep(5)
        logging.warning("Configurando os ativos da loja para o canal....")
        configure_store_assets(
            driver=driver, logo_path=logo_path, banner_path=banner_path
        )

        time.sleep(5)
        logging.warning("Configurando o perfil do canal....")
        configure_channel_profile(driver=driver)

        time.sleep(5)
        logging.warning("Ajustando as configuracoes de monetizacao do canal....")
        configure_monetization(driver=driver)

        time.sleep(5)
        logging.warning("Configurando e enviando o pacote do canal....")
        configure_channel_package(
            driver=driver,
            file_path=file_path,
        )

        driver.get(url)
        logging.warning("Configurando links direto para o canal....")
        configure_direct_link(driver=driver)
        time.sleep(5)
        driver.get(url)

        time.sleep(10)
        logging.warning("Configurando as credenciais de teste....")
        configure_test_credentials(driver)
        driver.get(url)

        time.sleep(5)
        logging.warning("Agendando publicacao do canal....")
        schedule_publication(driver)

        time.sleep(30)
        logging.warning("Publicacao do canal foi agendada com sucesso....")
        driver.quit()
    else:
        logging.warning("Google detectou resolucao de captcha automatica...")
        logging.warning("Tentando novamente em 1 minuto...")
        time.sleep(60)
        driver.quit()
        main()


if __name__ == "__main__":
    main()
