function init()
    m.top.functionName = "getUpdateWatchingTimeResponseDTO"
end function

function UpdateWatchingTimeDTO(providerURL, email, profileId, vodName, time) as object
    return {
        providerURL: providerURL
        email: email
        profileId: profileId
        vodName: vodName
        time: time
    }
end function

function UpdateWatchingTimeResponseDTO(status, msg) as object
    return {
        status: status
        msg: msg
    }
end function

function getUpdateWatchingTimeResponseDTO() as string
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    updateWatchingTime = UpdateWatchingTimeDTO(m.top.providerURL, m.top.email, m.top.profileId, m.top.vodName, m.top.time)
    request.SetUrl("https://" + updateWatchingTime.providerURL + "/profile-vod/" + updateWatchingTime.email + "/" + updateWatchingTime.profileId + "/vod/watching/" + updateWatchingTime.vodName)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.SetRequest("PUT")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    body = FormatJson(updateWatchingTime, 1)
    if (request.AsyncPostFromString(body))
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            if (code = 200)
                response = UpdateWatchingTimeResponseDTO(code, "Watching time updated sucessfully.")
            else
                response = UpdateWatchingTimeResponseDTO(code, "Unexpected erro.")
            end if

            m.top.UpdateWatchingTimeResponseDTO = FormatJson(response)
            print m.top.UpdateWatchingTimeResponseDTO

            return m.top.UpdateWatchingTimeResponseDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end function