function init()
    m.top.functionName = "perform"
end function

function perform() as void

    epgRequestDTO = {
        provider: m.top.providerURL,
        token: m.top.token,
        guideId: m.top.guideId,
    }

    url = "https://" + epgRequestDTO.provider + "" + epgRequestDTO.guideId + "?t=" + epgRequestDTO.token + "&now"
    
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)
    request.SetUrl(url)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.InitClientCertificates()

    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            response = msg.GetString()
            epgListDTO = CreateObject("roArray", 10, true)
            if (code = 200)
                response = ParseJSON(msg.GetString())
                for each epg in response
                    epgDTO = {
                        stop: epg.stop,
                        category: epg.category,
                        desc: epg.desc,
                        subtitle: epg.subtitle,
                        start: epg.start,
                        rating: epg.rating,
                        title: epg.title
                    }
                    epgListDTO.push(epgDTO)
                end for
            end if
            m.top.epgListResponseDTO = epgListDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end function
