function init()
    m.top.functionName = "getAuthResponse"
end function

function getAuthResponse()
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    authDTO = {
        username: m.top.username,
        password: m.top.password,
    }

    provider = getProviderFromSection()
    url = "https://" + provider + "/auth"
    request.SetUrl("https://" + provider + "/auth")
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    body = FormatJson(authDTO, 1)
    if (request.AsyncPostFromString(body))
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            response = msg.GetString()
            if (code = 200)
                authResponse = ParseJSON(msg.GetString())
                authResponseDTO = {
                    status: "ok",
                    data: {
                        economic: authResponse.economic,
                        email: authResponse.email,
                        expire: authResponse.expire,
                        lifetime: authResponse.lifetime,
                        name: authResponse.name,
                        parental: authResponse.parental,
                        parpass: authResponse.parpass,
                        rating: handleRatingType(authResponse.rating),
                        rtoken: authResponse.rtoken,
                        svod: authResponse.svod,
                        token: authResponse.token,
                        username: authResponse.username,
                        validated_email: authResponse.validated_email
                    },
                    msg: tr("Usuário autenticado com sucesso!")
                }
            else if (code = 401)
                authResponseDTO = {
                    status: "unauthorized",
                    data: {},
                    msg: tr("Credenciais de acesso inválidas.") + "(" + Str(code) + " )"
                }
            else if (code = 403)
                authResponseDTO = {
                    status: "forbidden",
                    data: {},
                    msg: tr("Usuário bloqueado.") + " (" + Str(code) + " )"
                }
            else if (code = 429)
                authResponseDTO = {
                    status: "forbidden",
                    data: {},
                    msg: tr("Máximo de sessões atingidas.") + " (" + Str(code) + " )"
                }
            else
                authResponseDTO = {
                    status: "unexpected",
                    data: {},
                    msg: tr("Erro inesperado, entre em contato com seu provedor de internet.") + " (" + Str(code) + " )"
                }
            end if
            m.top.authResponseDTO = FormatJson(authResponseDTO)
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end function

function handleRatingType(rating) as integer
    print type(rating)
    if type(rating) = "Integer" then return rating
    return rating.toInt()
end function

function getProviderFromSection() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("providerURL")
        return section.Read("providerURL")
    end if
    return invalid
end function