
sub init()
  m.top.setFocus(true)
  m.Logo = m.top.findNode("Logo")
  m.Logo.uri = "https://" + getProviderFromSection() + "/logo/main-logo.png"
  m.Logo.width = 800
  m.Logo.height = 120
  m.top.signalBeacon("AppLaunchComplete")

  m.UsernameLabel = m.top.findNode("UsernameLabel")
  m.UsernameInput = m.top.findNode("UsernameInput")
  m.UsernameLabel.text = tr("Usuário")
  m.UsernameInput.active = true

  m.PasswordLabel = m.top.findNode("PasswordLabel")
  m.PasswordLabel.text = tr("Senha")
  m.PasswordInput = m.top.findNode("PasswordInput")

  m.SubmitButton = m.top.findNode("SubmitButton")
  m.SubmitButton.buttons = [tr("Entrar")]
  m.SubmitButton.minWidth = 200
  m.SubmitButton.observeField("buttonSelected", "onButtonSelectedHandler")

  m.InfoPaneMessage = m.top.findNode("InfoPaneMessage")

  m.AuthTask = m.top.findNode("AuthTask")
  m.authTask.observeField("authResponseDTO", "AuthRequestListener")
  loadConfig()
  setElementsPosition()

  m.store = CreateObject("roSGNode", "ChannelStore")
  m.store.requesteduserdata = "email"
  info = CreateObject("roSGNode", "ContentNode")
  info.addFields({context: "signin"})
  m.store.requestedUserDataInfo = info
  m.store.command = "getUserData"
  m.store.observeField("userData", "userDataListener")


  m.store.ObserveField("storeChannelCredDataStatus", "onStoreChannelCredData")



end sub

function isNullOrEmpty(obj)
  if obj = invalid return true
  if Len(obj) = 0 return true
  return false
end function

function onStoreChannelCredData() as void
  print "onStoreChannelCredData"
  if (m.store.storeChannelCredDataStatus <> invalid)
      print "- response: " m.store.storeChannelCredDataStatus.response
      print "- status: " m.store.storeChannelCredDataStatus.status
      redirectScreenTo("ChannelsScene")
  end if
end function

sub userDataListener()
  if m.store.userData = invalid then return
  if m.store.userData.email <> invalid then m.UsernameInput.text = m.store.userData.email
end sub

sub loadKeyboardUsernameInput()
  m.KeyboardUsernameInput = createObject("roSGNode", "StandardKeyboardDialog")
  m.KeyboardUsernameInput.title = tr("Digite seu usuário")
  m.KeyboardUsernameInput.buttons = ["OK"]
  m.KeyboardUsernameInput.text = m.UsernameInput.text
  m.KeyboardUsernameInput.observeField("buttonSelected", "onUsernameInputButtonSelectedHandler")
  showDialog(m.KeyboardUsernameInput)
end sub

sub loadKeyboardPasswordInput()
  m.KeyboardPasswordInput = createObject("roSGNode", "StandardKeyboardDialog")
  m.KeyboardPasswordInput.title = tr("Digite sua senha")
  m.KeyboardPasswordInput.TextEditBox.secureMode = true
  m.KeyboardPasswordInput.text = m.PasswordInput.text
  m.KeyboardPasswordInput.buttons = ["OK"]
  m.KeyboardPasswordInput.observeField("buttonSelected", "onPasswordInputButtonSelectedHandler")
  showDialog(m.KeyboardPasswordInput)
end sub

sub setElementsPosition()
  logoRect = m.Logo.boundingRect()
  centerx = (1920 - logoRect.width) / 2
  m.Logo.translation = [centerx, 50]

  m.UsernameLabel.translation = [70, 200]
  m.UsernameInput.translation = [50, 250]

  m.PasswordLabel.translation = [70, 350]
  m.PasswordInput.translation = [50, 400]

  m.SubmitButton.translation = [50, 500]
  m.InfoPaneMessage.translation = [50, 600]
  m.InfoPaneMessage.height = 150
  m.InfoPaneMessage.visible = false
end sub

sub deleteProviderOnSection() as void
  section = CreateObject("roRegistrySection", "Authentication")
  section.Delete("providerURL")
  section.Flush()
end sub

sub AuthRequestListener()
  if m.authTask.authResponseDTO <> ""
    response = ParseJSON(m.authTask.authResponseDTO)

    if response.status = "ok"

      print "StoreChannelCredData"
      m.store.channelCredData = FormatJson(response.data)
      print "store.channelCredData: " m.store.channelCredData
      m.store.command = "storeChannelCredData"
      setUserOnSection(FormatJson(response.data))
      if m.global.deeplink <> invalid
        m.VODDetails = CreateObject("roSGNode", "VODDetailsTask")
        m.VODDetails.providerURL = getProviderFromSection()
        m.VODDetails.email = response.data.email
        m.VODDetails.user = response.data.name
        m.VODDetails.vodName = m.global.deeplink.contentId
        m.VODDetails.control = "RUN"
        m.VODDetails.observeField("VODDetailsDTO", "VODDetailsDTOListener")
        redirectScreenTo("ChannelsScene")
      end if
    else
      displayMessage(response.msg, response.status)
    end if
  end if
end sub

function VODDetailsDTOListener()
  if m.VODDetails.VODDetailsDTO = invalid then return invalid
  if m.VODDetails.VODDetailsDTO.status = "NOT_FOUND"
    redirectScreenTo("ChannelsScene")
    return invalid
  end if
  setVodName(m.global.deeplink.contentId)
  if m.global.deeplink.mediaType = "movie" or m.global.deeplink.mediaType = "episode" or m.global.deeplink.mediaType = "series"
    redirectScreenTo("VODPlayerScene")
  else if m.global.deeplink.mediaType = "season"
    redirectScreenTo("VodInternalScene")
  else
    redirectScreenTo("ChannelsScene")
  end if

end function

sub handleAuthRequest(username as string, password as string) as object
  m.authTask = m.top.findNode("AuthTask")
  m.authTask.username = username
  m.authTask.password = password
  m.authTask.control = "RUN"
end sub

function displayMessage(msg, status)
  m.InfoPaneMessage.textColor = "#FFFFFF"
  m.InfoPaneMessage.infoText = "Erro: " + chr(10) + chr(10) + msg + ""
  m.InfoPaneMessage.visible = true
end function

function loadConfig() as void
  m.configTask = createObject("roSGNode", "ConfigTask")
  m.configTask.control = "RUN"
  m.configTask.observeField("configDTO", "configDTOListener")
end function

function configDTOListener() as void
  if m.configTask.configDTO = invalid then return
  m.configDTO = m.configTask.configDTO

end function

sub onButtonSelectedHandler()
  if m.SubmitButton.buttonSelected = 0
    handleAuthRequest(m.UsernameInput.text, m.PasswordInput.text)
  end if
end sub

sub onUsernameInputButtonSelectedHandler()
  if m.KeyboardUsernameInput.buttonSelected = 0
    print "ok"
    m.UsernameInput.text = m.KeyboardUsernameInput.text
    m.KeyboardUsernameInput.close = true
  end if
end sub

sub onPasswordInputButtonSelectedHandler()
  if m.KeyboardPasswordInput.buttonSelected = 0
    print "ok"
    m.PasswordInput.text = m.KeyboardPasswordInput.text
    m.KeyboardPasswordInput.close = true
    m.PasswordInput.setFocus(false)
    m.PasswordInput.active = false
    m.SubmitButton.setFocus(true)
  end if
end sub

function shouldBackToProviderScreen(key) as boolean
  return key = "back" and m.configDTO.hasProviderList
end function

function shouldShowExit(key) as boolean
  return key = "back" and not m.configDTO.hasProviderList
end function

function showExitDialog()
  dialog = createObject("roSGNode", "Dialog")
  dialog.id = "playerError"
  dialog.title = tr("Sair da aplicação")
  dialog.message = tr("Deseja sair da aplicação?")
  dialog.buttons = [tr("Sair"), tr("Cancelar")]
  dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
  dialog.observeField("wasClosed", "onDialogClose")
  showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
  if m.top.getParent().dialog.buttonSelected = 0
      m.label = m.top.getParent().findNode("exitApp")
      m.label.setField("text", "close")
  else
      m.top.getParent().dialog.close = true
  end if
endfunction

function onKeyEvent(key as string, press as boolean) as boolean
  print "in SignInScene.xml onKeyEvent ";key;" "; press
  handled = false
  if press then
    
    if shouldBackToProviderScreen(key)
      deleteProviderOnSection()
      redirectScreenTo("ProviderSelectionScene")
      handled = true

    else if shouldShowExit(key)
      showExitDialog()

    else if (m.UsernameInput.active and key = "OK")
      loadKeyboardUsernameInput()
      handled = true

    else if (m.UsernameInput.active and key = "down")
      m.UsernameInput.active = false
      m.UsernameInput.setFocus(false)
      m.PasswordInput.active = true
      m.PasswordInput.setFocus(true)
      handled = true

    else if (m.PasswordInput.active and key = "OK")
      loadKeyboardPasswordInput()
      handled = true

    else if (m.PasswordInput.active and key = "down")
      m.PasswordInput.active = false
      m.PasswordInput.setFocus(false)
      m.SubmitButton.active = true
      m.SubmitButton.setFocus(true)
      handled = true

    else if (m.PasswordInput.active and key = "up")
      m.PasswordInput.active = false
      m.UsernameInput.active = true
      m.UsernameInput.setFocus(true)
      handled = true

    else if (key = "up" and m.SubmitButton.isInFocusChain())
      m.SubmitButton.setFocus(false)
      m.PasswordInput.active = true
      m.PasswordInput.setFocus(true)
      handled = true
    end if
    handled = true
    return handled
  end if

  return handled

end function
