function init()
    m.messageLabel = m.top.findNode("messageLabel")
    m.ButtonGroup = m.top.findNode("ButtonGroup")
    m.ButtonGroup.buttons = [tr("Tentar novamente"), tr("Sair")]
    m.ButtonGroup.observeField("buttonSelected", "onButtonSelectedHandler")
    m.messageLabel.translation = [getCenteredX(m.messageLabel.boundingRect().width), 300]
    m.ButtonGroup.translation = [getCenteredX(m.ButtonGroup.boundingRect().width), 420]
    m.ButtonGroup.setFocus(true)
    m.focusedIndex = 0
    m.ButtonGroup.getChild(0).setFocus(true)
end function

function onButtonSelectedHandler()
    if m.ButtonGroup.buttonSelected = 0
        onTryAgain()
    else
        showExitDialog()
    end if
end function

function onTryAgain()
    print "Tentando reconectar..."
    MainScene = m.top.getParent()
    if MainScene <> invalid then
        params = { scene: m.top }
        MainScene.callFunc("reloadMainScene", params)
    end if
end function

function onExitApp()
    print "Fechando o aplicativo..."
    mainScene = m.top.getParent()
    m.label = mainScene.findNode("exitApp")
    m.label.setField("text", "close")
    end
end function

function onKeyEvent(key as string, press as boolean) as boolean
    handled = false
    if press
        if key = "left"
            m.focusedIndex = (m.focusedIndex - 1 + m.ButtonGroup.buttons.count()) mod m.ButtonGroup.buttons.count()
            updateButtonFocus()
            handled = true
        else if key = "right"
            m.focusedIndex = (m.focusedIndex + 1) mod m.ButtonGroup.buttons.count()
            updateButtonFocus()
            handled = true
        else if key = "OK"
            m.ButtonGroup.buttonSelected = m.focusedIndex
            onButtonSelectedHandler()
            handled = true
        end if
    end if
    return handled
end function

function showExitDialog()
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "playerError"
    dialog.title = tr("Sair da aplicação")
    dialog.message = tr("Deseja sair da aplicação?")
    dialog.buttons = [tr("Sair"), tr("Cancelar")]
    dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
    dialog.observeField("wasClosed", "onDialogClose")
    showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        m.label = m.top.getParent().findNode("exitApp")
        m.label.setField("text", "close")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function updateButtonFocus()
    for i = 0 to m.ButtonGroup.buttons.count() - 1
        m.ButtonGroup.getChild(i).setFocus(false)
    end for
    m.ButtonGroup.getChild(m.focusedIndex).setFocus(true)
end function
