function init()
    m.providerURL = getProviderFromSection()
    m.user = getUserFromSection()
    m.store = CreateObject("roSGNode", "ChannelStore")
    m.store.ObserveField("channelCred", "onGetChannelCred")
    m.busyspinner = m.top.findNode("spinner")
    m.busyspinner.poster.observeField("loadStatus", "showspinner")
    m.busyspinner.poster.uri = "pkg:/images/busyspinner_hd.png"
    print "GetChannelCred"
    m.store.command = "getChannelCred"
    m.global.observeField("deeplink", "deeplinkListener")
end function

sub showspinner()
    if m.busyspinner.poster.loadStatus = "ready"
        m.busyspinner.poster.scale = [1.5, 1.5]
        m.busyspinner.translation = [getCenteredX(m.busyspinner.poster.bitmapWidth), getCenteredY(m.busyspinner.poster.bitmapHeight)]
        m.busyspinner.visible = true
        m.busyspinner.spinInterval = 1.5
    end if
end sub

function onGetChannelCred() as void
    print "onGetChannelCred"
    if m.store.channelCred = invalid then return 
    if not isNullOrEmpty(m.store.channelCred.json)
        json = ParseJson(m.store.channelCred.json)
        if json <> invalid and not isNullOrEmpty(json.channel_data) and not json.channel_data = "null"
            print "- error: "; json.error
            setUserOnSection(json.channel_data)
        end if
    end if
    if not isInternetAvailable()
        redirectTo("NetworkErrorScene")
        m.busyspinner.visible = false
        return
    end if
    if isUserAuthenticated(m.user, m.providerURL)
        if m.global.deeplink = invalid
            redirectTo("ChannelsScene")
            m.busyspinner.visible = false
            return
        endif
        m.VODDetails = CreateObject("roSGNode", "VODDetailsTask")
        m.VODDetails.providerURL = m.providerURL
        m.VODDetails.email = m.user.email
        m.VODDetails.user = m.user.username
        m.VODDetails.vodName = m.global.deeplink.contentId
        m.VODDetails.control = "RUN"
        m.VODDetails.observeField("VODDetailsDTO", "VODDetailsDTOListener")
    else if existingProviderURL(m.providerURL)
        redirectTo("SignInScene")
    else
        redirectTo("ProviderSelectionScene")
    end if
    m.busyspinner.visible = false
    notifyRokuUserIsLoggedIn()
end function

function reloadMainScene(params as Object)
    m.top.removeChild(params.scene) ' remove the current scene
    init()
end function

function isNullOrEmpty(obj)
    if obj = invalid return true
    if Len(obj) = 0 return true
    return false
end function

function notifyRokuUserIsLoggedIn(rsgScreen = invalid as object)
    if type(m.top) = "roSGNode"
        globalNode = m.global
    else
        globalNode = rsgScreen.getGlobalNode()
    end if

    ' get the Roku Analytics Component Library used for RED
    RAC = globalNode.roku_event_dispatcher
    if RAC = invalid then
        RAC = createObject("roSGNode", "Roku_Analytics:AnalyticsNode")
        RAC.debug = true ' for verbose output to BrightScript console, optional
        RAC.init = { RED: {} } ' activate RED as a provider
        globalNode.addFields({ roku_event_dispatcher: RAC })
    end if

    ' dispatch an event to Roku
    RAC.trackEvent = { RED: { eventName: "Roku_Authenticated" } }
end function


function deeplinkListener()
    if isUserAuthenticated(m.user, m.providerURL)
        if m.global.deeplink <> invalid
            m.VODDetails = CreateObject("roSGNode", "VODDetailsTask")
            m.VODDetails.providerURL = m.providerURL
            m.VODDetails.email = m.user.email
            m.VODDetails.user = m.user.username
            m.VODDetails.vodName = m.global.deeplink.contentId
            m.VODDetails.control = "RUN"
            m.VODDetails.observeField("VODDetailsDTO", "VODDetailsDTOLinkDeepListener")
        end if
    end if
end function

function VODDetailsDTOLinkDeepListener()
    if m.VODDetails.VODDetailsDTO = invalid then return invalid
    if m.VODDetails.VODDetailsDTO.status = "NOT_FOUND"
        redirectToWhenDeepLink("ChannelsScene")
        return invalid
    end if

    setVodName(m.global.deeplink.contentId)

    if m.global.deeplink.mediaType = "movie" or m.global.deeplink.mediaType = "episode" or m.global.deeplink.mediaType = "series"
        redirectToWhenDeepLink("VODPlayerScene")
    else if m.global.deeplink.mediaType = "season"
        redirectToWhenDeepLink("VodInternalScene")
    else
        redirectToWhenDeepLink("ChannelsScene")
    end if
end function

function redirectToWhenDeepLink(sceneName)
    scene = CreateObject("roSGNode", sceneName)
    m.top.removeChildIndex(2)
    m.top.appendChild(scene)
    scene.setFocus(true)
end function

function VODDetailsDTOListener()
    if m.VODDetails.VODDetailsDTO = invalid then return invalid
    if m.VODDetails.VODDetailsDTO.status = "NOT_FOUND"
        redirectTo("ChannelsScene")
        return invalid
    end if
    setVodName(m.global.deeplink.contentId)
    if m.global.deeplink.mediaType = "movie" or m.global.deeplink.mediaType = "episode" or m.global.deeplink.mediaType = "series"
        redirectScreenTo("VODPlayerScene")
    else if m.global.deeplink.mediaType = "season"
        redirectScreenTo("VodInternalScene")
    else
        redirectTo("ChannelsScene")
    end if

end function

function isUserAuthenticated(user, providerURL) as boolean
    return user <> invalid and providerURL <> invalid
end function

function existingProviderURL(providerURL) as boolean
    return providerURL <> invalid
end function

function setDeepLinking()
    print "deep linking"; m.top.deepLinking
end function

function setCurrentVODOnSection(vod)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("currentVOD", vod)
    section.Flush()
end function
