function init()
    m.top.functionName = "perform"
end function

function VODSearchRequestDTO(providerURL as string, token as string, query as string, username as string)
    return {
        providerURL: providerURL
        token: token
        query: query
        username: username
    }
end function

function VODSearchDTO(response)
    vods = []

    for each vod in response.vods
        vod_dto = VODDTO(vod)
        if vod_dto.selling = false
            vods.push(VODDTO(vod))
        endif
    end for

    return {
        vods: vods
    }
end function

function VODDTO(vod)
    return {
        name: vod.name,
        selling: vod.selling,
        poster: "https://" + m.top.providerURL + "/images/" + vod.name + "_poster.jpg_280_280"
    }
end function

function isResponseInvalid(code, responseText) as boolean
    return code <> 200 or responseText = ""
end function

function VODSearchResponseDTO(data, status, statusCode, hasError)
    now = CreateObject("roDateTime")

    return {
        data: data,
        status: status,
        statusCode: statusCode,
        hasError: hasError
        updatedAt: now.asSeconds()
    }
end function

function perform() as object
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    m.VODSearchRequestDTO = VODSearchRequestDTO(m.top.providerURL, m.top.token, m.top.query, m.top.username)
    request.SetMessagePort(port)
    print "https://" + m.VODSearchRequestDTO.providerURL + "/app/search/" + m.VODSearchRequestDTO.query + "?t=" + m.VODSearchRequestDTO.token
    request.SetUrl("https://" + m.VODSearchRequestDTO.providerURL + "/app/search/" + m.VODSearchRequestDTO.query + "?t=" + m.VODSearchRequestDTO.token)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()
    if (request.AsyncGetToString())
        msg = wait(60000, port)
        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            responseText = msg.GetString()

            if isResponseInvalid(code, responseText)
                m.top.VODSearchResponseDTO = VODSearchResponseDTO(responseText, "Unexpected", code, true)
                print m.top.VODSearchResponseDTO
                return m.top.VODSearchResponseDTO
            end if

            response = ParseJSON(responseText)
            m.top.VODSearchResponseDTO = VODSearchResponseDTO(VODSearchDTO(response), "Success", code, false)
            return m.top.VODSearchResponseDTO

        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
    return invalid
end function