
function init()
  m.Logo = m.top.findNode("Logo")
  m.Logo.width = 700
  m.Logo.height = 120
  m.top.signalBeacon("AppLaunchComplete")

  m.ProviderLabel = m.top.findNode("ProviderLabel")

  m.ProviderInput = m.top.findNode("ProviderInput")
  m.ProviderInput.observeField("text", "onTextChangeHandler")

  m.ButtonGroup = m.top.findNode("ButtonGroup")

  m.ProvidersRBList = m.top.findNode("ProvidersRBList")
  m.ProvidersRBList.observeField("checkedItem", "checkedProviderHandler")

  m.Video = m.top.findNode("Video")

  m.ButtonGroup.buttons = [tr("Próximo")]
  m.ButtonGroup.observeField("buttonSelected", "onButtonSelectedHandler")

  loadConfig()
  getProviderFromSection()
  setElementsPosition()
end function

function loadConfig() as void
  m.configTask = createObject("roSGNode", "ConfigTask")
  m.configTask.control = "RUN"
  m.configTask.observeField("configDTO", "configDTOListener")
end function

function configDTOListener() as void
  if m.configTask.configDTO = invalid then return
  m.configDTO = m.configTask.configDTO
  m.ProviderInput.setFocus(true)

  if not m.configDTO.isDemo
    m.ProviderLabel.text = tr("Selecione o domínio")
  else
    m.ProviderLabel.text = tr("Selecione seu provedor de internet")
  end if

  if not m.configDTO.hasProviderList
    setProviderOnSection(m.configDTO.providerURL)
    redirectScreenTo("SignInScene")
    return
  end if

  m.Logo.uri = "https://" + m.configDTO.providerURL + "/logo/main-logo.png"
  m.providersListDTO = []
  m.ProvidersTask = m.top.findNode("ProvidersTask")
  m.ProvidersTask.providersListURL = m.configDTO.providersListURL
  m.ProvidersTask.control = "RUN"
  m.ProvidersTask.observeField("providersListDTO", "loadProvidersHandler")

end function

function onTextChangeHandler() as void
  if m.ProvidersTask.providersListDTO = invalid then return

  if Len(m.ProviderInput.text) >= 3
    filteredProviders = []

    for each provider in m.providersListDTO
      if Instr(0, LCase(provider["name"]), LCase(m.ProviderInput.text)) > 0
        filteredProviders.push(provider)
      end if
    end for

    m.ProvidersRBList.content = mapProvidersResponseToNodeContent(filteredProviders)

  end if

end function

function onButtonSelectedHandler()
  if m.ButtonGroup.buttonSelected = 0
    selectedProvider = m.ProvidersRBList.content.getChild(m.ProvidersRBList.checkedItem)
    if selectedProvider = invalid
      dialog = createObject("roSGNode", "Dialog")
      dialog.id = "providerNotSelectedError"
      dialog.title = tr("Você deve selelecionar um provedor antes de continuar")
      dialog.message = tr("Pesquise pelo seu provedor e o selecione para prosseguir.")
      showDialog(dialog)
    else
      setProviderOnSection(selectedProvider.id)
      redirectScreenTo("SignInScene")
    end if

  end if
end function

function loadProvidersHandler()
  m.providersListDTO = m.ProvidersTask.providersListDTO
  if not m.configDTO.isDemo
    m.ProvidersRBList.content = mapProvidersResponseToNodeContent(m.ProvidersTask.providersListDTO)
  end if
  print "m.providersListDTO="; m.providersListDTO
end function

function setElementsPosition()
  logoRect = m.Logo.boundingRect()
  centerx = (1920 - logoRect.width) / 2
  m.Logo.translation = [centerx, 50]

  providerInputRect = m.ProviderInput.boundingRect()
  m.ProviderInput.translation = [50, 250]
  m.ProviderLabel.translation = [70, 200]

  m.ProvidersRBList.translation = [providerInputRect.width + 80, 250]
  y = m.ProviderInput.translation[1]
  m.ButtonGroup.translation = [70, providerInputRect.height + y]
end function

function mapProvidersResponseToNodeContent(providersListDTO) as dynamic
  content = createObject("roSGNode", "ContentNode")

  for each provider in providersListDTO
    content_child = content.createChild("ContentNode")
    content_child.title = "(" + provider.name + ") " + provider.edge
    content_child.id = provider.edge
  end for

  return content
end function

function checkedProviderHandler()
  m.ButtonGroup.setFocus(true)
end function

function showExitDialog()
  dialog = createObject("roSGNode", "Dialog")
  dialog.id = "playerError"
  dialog.title = tr("Sair da aplicação")
  dialog.message = tr("Deseja sair da aplicação?")
  dialog.buttons = [tr("Sair"), tr("Cancelar")]
  dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
  dialog.observeField("wasClosed", "onDialogClose")
  showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
  if m.top.getParent().dialog.buttonSelected = 0
      m.label = m.top.getParent().findNode("exitApp")
      m.label.setField("text", "close")
  else
      m.top.getParent().dialog.close = true
  end if
endfunction

function onKeyEvent(key as string, press as boolean) as boolean
  print "in ProviderSelectionScene.xml onKeyEvent ";key;" "; press
  if press then
    if key = "back"
      print "------ [back pressed] ------"
      showExitDialog()
      return true
    else if key = "OK"
      print "------- [ok pressed] -------"
    else if key = "down" and not m.ButtonGroup.hasFocus()
      m.ButtonGroup.setFocus(true)
    else if key = "up" and not m.ProviderInput.hasFocus()
      m.ProviderInput.setFocus(true)
      return false
    else if key = "right" and not m.ProvidersRBList.hasFocus()
      m.ProvidersRBList.setFocus(true)
      return false
    else if key = "left" and m.ProvidersRBList.hasFocus()
      m.ButtonGroup.setFocus(true)
      return false
    end if

  end if
  return false
end function
