function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    m.mainLogo = m.top.findNode("mainLogo")
    m.mainLogo.uri = "https://" + m.providerURL + "/logo/main-logo.png_150_150"
    m.logout = m.top.findNode("logout")
    m.logout.setFocus(true)
    m.parental = m.top.findNode("parental")
    m.parental.text = tr("Alterar senha para conteúdo adulto")
    m.parental.setFocus(false)
    loadRefreshToken()

    m.VODsTask = createObject("roSGNode", "VODsTask")
    m.VODsTask.token = m.user.token
    m.VODsTask.email = m.user.email
    m.VODsTask.username = m.user.username
    m.VODsTask.providerURL = m.providerURL
    m.VODsTask.control = "RUN"
    m.VODsTask.observeField("VODCategoriesListDTO", "VODsOnLoad")

    m.menu = m.top.findNode("menu")
    m.menu.observeField("itemSelected", "itemSelectedListener")
    
    m.logout.observeField("buttonSelected", "onButtonSelectedListener")
    m.logout.text = tr("Logout")
    m.name = m.top.findNode("name")
    m.email = m.top.findNode("email")
    m.parentalText = m.top.findNode("parentalText")
    m.name.text = tr("Bem vindo") + ", " + m.user.username
    m.email.text = m.user.email
    m.parentalText.text = tr("Conteudo adulto")

    m.store = CreateObject("roSGNode", "ChannelStore")
    
end function

function VODsOnLoad()
    shouldDisplayVod = true
    if m.VODsTask.VODCategoriesListDTO.hasError then shouldDisplayVod = false

    loadMenu(shouldDisplayVod)
endfunction

function loadMenu(shouldDisplayVod as boolean)
    content = createObject("roSGNode", "ContentNode")
    
    createMenuItem(content, "channels", tr("Canais"))
    createMenuItem(content, "profile", tr("Perfil"))
    if shouldDisplayVod then createMenuItem(content, "vods", tr("Filmes e Séries"))
    
    m.menu.content = content
endfunction

function createMenuItem(content as dynamic, id as String, title as String)
    menuItem = content.createChild("ContentNode")
    menuItem.id = id
    menuItem.title = title
end function

function onButtonSelectedListener()
    m.store.ObserveField("storeChannelCredDataStatus", "onStoreChannelCredData")

    print "StoreChannelCredData"
    m.store.channelCredData = FormatJson(invalid)
    m.store.command = "storeChannelCredData"

end function

function onStoreChannelCredData() as void
    print "onStoreChannelCredData"
    if (m.store.storeChannelCredDataStatus <> invalid)
        print "- response: " m.store.storeChannelCredDataStatus.response
        print "- status: " m.store.storeChannelCredDataStatus.status
        print("Removing user from section.")
        deleteUserOnSection()
        print("Redirecting user to ProviderSelectionScene.")
        redirectScreenTo("ProviderSelectionScene")
    end if
  end function

function itemSelectedListener()
    selectedItem = m.menu.content.getChild(m.menu.itemFocused)
    if selectedItem.id = "channels"
        redirectScreenTo("ChannelsScene")
    else if selectedItem.id = "vods"
        redirectScreenTo("VodsScene")
    end if
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"
end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        print("Status: " + response.status)
        if response.status = "ok"
            print("Refreshing token...")
            if getUserFromSection() = invalid
                return invalid
            end if
            user = getUserFromSection()
            print("Current token: " + user.token)
            print("New token: " + response.data.token)
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            print("Token refreshed.")
        else
            print("Removing user from section.")
            print(response.msg)
            deleteUserOnSection()
            print("Redirecting user to ProviderSelectionScene.")
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

    m.logout.setFocus(true)
end function

function rowListChannelsListener()
    if m.rowListChannelsTask.content = invalid
        print "invalid rowListChannelsTask.content"
    else
        m.channelZoomRowList.content = m.rowListChannelsTask.content
        m.channelZoomRowList.visible = true
    end if
end function

function showExitDialog()
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "playerError"
    dialog.title = tr("Sair da aplicação")
    dialog.message = tr("Deseja sair da aplicação?")
    dialog.buttons = [tr("Sair"), tr("Cancelar")]
    dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
    dialog.observeField("wasClosed", "onDialogClose")
    showDialog(dialog)
end function

function showParentalDialog()
    m.dialog = createObject("roSGNode", "StandardPinPadDialog")
    m.dialog.id = "parentalPassword"
    m.dialog.title = tr("Alterar senha para conteúdo adulto")
    m.dialog.buttons = [tr("Continuar"), tr("Cancelar")]
    m.dialog.observeField("buttonSelected", "confirmPassword")
    m.dialog.observeField("wasClosed", "closeDialog")
    showDialog(m.dialog)
end function

function buttonSelectedOnExitDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        m.label = m.top.getParent().findNode("exitApp")
        m.label.setField("text", "close")
    else
        m.top.getParent().dialog.close = true
    end if
end function

function confirmPassword()
    if m.dialog.buttonSelected = 0
        showConfirmPasswordDialog()
    else
        closeDialog()
    end if
    
end function

function showConfirmPasswordDialog()
    m.confirmDialog = createObject("roSGNode", "StandardPinPadDialog")
    m.confirmDialog.id = "confirmParentalPassword"
    m.confirmDialog.title = tr("Confirme a senha")
    m.confirmDialog.buttons = [tr("Continuar"), tr("Cancelar")]
    m.confirmDialog.observeField("buttonSelected", "updateParentPassword")
    m.confirmDialog.observeField("wasClosed", "closeConfirmDialog")
    showDialog(m.confirmDialog)
end function

function updateParentPassword()

    if m.confirmDialog.buttonSelected = 0
    
        if m.dialog.pin = m.confirmDialog.pin
            m.parentalTask =  createObject("roSGNode", "ParentalTask")
            m.parentalTask.parpass = m.dialog.pin
            m.parentalTask.control = "RUN"
            m.parentalTask.observeField("parentalResponseDTO", "parentalDTOListener")

        else
            showErrorMessageDialog(tr("As senhas não conferem"))
        
        end if
    else
        closeConfirmDialog()
    end if
end function

function parentalDTOListener() as void
    if m.parentalTask.parentalResponseDTO = invalid then 
        showErrorMessageDialog(tr("Erro inesperado, entre em contato com seu provedor de internet."))
        return
    end if

    responseDTO = ParseJSON(m.parentalTask.parentalResponseDTO)
  
    if responseDTO.status = "ok"
        showSuccessDialog(tr("Senha alterada com sucesso."))
    else
        showErrorMessageDialog(tr("Erro inesperado, entre em contato com seu provedor de internet."))
    end if
end function

function showSuccessDialog(message as String) as void
    m.responseDialog = CreateObject("roSGNode", "Dialog")
    m.responseDialog.title = tr("Sucesso")
    m.responseDialog.message = message
    m.responseDialog.buttons = [tr("Ok")]
    m.responseDialog.observeField("buttonSelected", "onDialogButtonSelected")
    showDialog(m.responseDialog)
end function

function showErrorMessageDialog(message as String) as void
    m.responseDialog = CreateObject("roSGNode", "Dialog")
    m.responseDialog.title = tr("Erro")
    m.responseDialog.message = message
    m.responseDialog.buttons = [tr("Ok")]
    m.responseDialog.observeField("buttonSelected", "onDialogButtonSelected")
    showDialog(m.responseDialog)
end function

function onDialogButtonSelected() as void
    m.dialog.close = true
    m.confirmDialog.close = true
    m.responseDialog.close = true
    m.parental.setFocus(false)
    m.logout.setFocus(true)
end function

function closeDialog() as void
    m.dialog.close = true
    m.parental.setFocus(false)
    m.logout.setFocus(true)
end function

function closeConfirmDialog() as void
    m.dialog.close = true
    m.confirmDialog.close = true
    m.parental.setFocus(false)
    m.logout.setFocus(true)
end function

function shouldShowExitModel(key as string) as boolean
    return m.menu.hasFocus() and key = "back"
end function

function shouldShowParentalModel(key as string) as boolean
    return m.parental.hasFocus() and key = "OK"
end function

function focusMenu()
    m.logout.setFocus(false)
    m.menu.setFocus(true)
end function

function shouldFocusMenu(key) as boolean
    return (key = "back" or key = "left") and m.logout.hasFocus()
end function

function onKeyEvent(key as string, press as boolean) as boolean
    print "in ProfileScene.xml onKeyEvent ";key;" "; press
    handled = false
    if press
        if shouldFocusMenu(key)
            focusMenu()
        else if shouldShowExitModel(key)
            showExitDialog()
        else if m.logout.hasFocus() and key = "down"
            m.parental.setFocus(true)
            m.logout.setFocus(false)
            handled = true
        else if m.parental.hasFocus() and key = "left"
            focusMenu()
        else if m.parental.hasFocus() and key = "up"
            m.logout.setFocus(true)
     
        end if
    else
        if key = "right" and m.menu.hasFocus()
            m.logout.setFocus(true)
        else if shouldShowParentalModel(key)
            showParentalDialog()
        end if
        handled = true
    end if
    return handled
end function
