function init()
    m.user = getUserFromSection()
    m.providerURL = getProviderFromSection()
    m.mainLogo = m.top.findNode("mainLogo")
    m.mainLogo.uri = "https://" + m.providerURL + "/logo/main-logo.png_150_150"
    m.menu = m.top.findNode("menu")

    m.VODsTask = createObject("roSGNode", "VODsTask")
    m.VODsTask.token = m.user.token
    m.VODsTask.email = m.user.email
    m.VODsTask.username = m.user.username
    m.VODsTask.providerURL = m.providerURL
    m.VODsTask.control = "RUN"
    m.VODsTask.observeField("VODCategoriesListDTO", "VODsOnLoad")
    m.pressback = m.top.findNode("pressback")
    m.pressback.text = tr("Pressione Voltar para acessar o menu")
    m.allchannels = m.top.findNode("allchannels")
    m.allchannels.text = tr("Todos os canais")
    
    m.menu.observeField("itemSelected", "itemSelectedListener")
    m.top.signalBeacon("AppLaunchComplete")

    loadRefreshToken()
    loadChannels()

    m.channelsTask.observeField("channelsListDTO", "channelsOnLoad")
    m.channelGridList = m.top.findNode("channelGridList")
    m.channelGridList.observeField("itemSelected", "itemSelected")
    m.top.visible = true

end function

function VODsOnLoad()
    shouldDisplayVod = true
    if m.VODsTask.VODCategoriesListDTO.hasError then shouldDisplayVod = false

    loadMenu(shouldDisplayVod)
endfunction

function loadMenu(shouldDisplayVod as boolean)
    content = createObject("roSGNode", "ContentNode")
    
    createMenuItem(content, "channels", tr("Canais"))
    createMenuItem(content, "profile", tr("Perfil"))
    if shouldDisplayVod then createMenuItem(content, "vods", tr("Filmes e Séries"))
    
    m.menu.content = content
endfunction

function createMenuItem(content as dynamic, id as String, title as String)
    menuItem = content.createChild("ContentNode")
    menuItem.id = id
    menuItem.title = title
end function

function itemSelectedListener()
    selectedItem = m.menu.content.getChild(m.menu.itemFocused)
    if selectedItem.id = "profile"
        redirectScreenTo("ProfileScene")
    else if selectedItem.id = "vods"
        redirectScreenTo("VodsScene")
    end if
end function

function loadRefreshToken()
    m.authRefreshTokenTask = m.top.findNode("AuthRefreshTokenTask")
    m.authRefreshTokenTask.observeField("authResponseDTO", "refreshTokenListener")
    m.authRefreshTokenTask.control = "RUN"

end function

function refreshTokenListener()
    if m.authRefreshTokenTask <> invalid
        response = ParseJson(m.authRefreshTokenTask.authResponseDTO)
        
        if response.status = "ok"
            
            user = getUserFromSection()
            
            
            user.token = response.data.token
            user.economic = response.data.economic
            user.expire = response.data.expire
            user.lifetime = response.data.lifetime
            user.parental = response.data.parental
            user.parpass = response.data.parpass
            user.rating = response.data.rating
            user.svod = response.data.svod
            user.validated_email = response.data.validated_email
            setUserOnSection(FormatJson(user))
            
        else
            
            
            deleteUserOnSection()
            
            redirectScreenTo("ProviderSelectionScene")
        end if
    end if

end function

function loadRowListChannels()
    m.gridListChannelsTask = createObject("roSGNode", "GridListChannelsTask")
    m.gridListChannelsTask.channelsListDTO = m.channelsListDTO
    m.gridListChannelsTask.observeField("content", "gridListChannelsListener")
    m.gridListChannelsTask.control = "RUN"

    m.channelGridList.visible = false
    m.channelGridList.setFocus(true)
end function

function gridListChannelsListener() as dynamic
    if m.gridListChannelsTask.content = invalid
        return invalid
    end if

    m.channelGridList.content = m.gridListChannelsTask.content
    m.channelGridList.visible = true
end function

function loadChannels()
    m.channelsTask = m.top.findNode("ChannelsTask")
    m.channelsTask.token = m.user.token
    m.channelsTask.providerURL = m.providerURL

    m.channelsTask.control = "RUN"
end function

function channelsOnLoad()
    m.channelsListDTO = m.channelsTask.channelsListDTO
    loadRowListChannels()
end function

function itemSelected()
    channelId = m.channelGridList.content.getChild(m.channelGridList.itemFocused).id
    setCurrentChannelOnSection(channelId)
    redirectScreenTo("ChannelPlayerScene")

end function

function setCurrentChannelOnSection(channelId)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("currentChannelId", channelId)
    section.Flush()
end function

function showExitDialog()
    dialog = createObject("roSGNode", "Dialog")
    dialog.id = "playerError"
    dialog.title = tr("Sair da aplicação")
    dialog.message = tr("Deseja sair da aplicação?")
    dialog.buttons = [tr("Sair"), tr("Cancelar")]
    dialog.observeField("buttonSelected", "buttonSelectedOnExitDialog")
    dialog.observeField("wasClosed", "onDialogClose")
    showDialog(dialog)
end function

function buttonSelectedOnExitDialog()
    if m.top.getParent().dialog.buttonSelected = 0
        m.label = m.top.getParent().findNode("exitApp")
        m.label.setField("text", "close")
    else
        m.top.getParent().dialog.close = true
    end if
endfunction

function shouldShowExitModel(key as string) as boolean
    return m.menu.hasFocus() and key = "back"
end function

function onKeyEvent(key as string, press as boolean) as boolean
    
    handled = false
    if press
        if (key = "back" or key = "left") and m.channelGridList.hasFocus()
            m.channelGridList.setFocus(false)
            m.menu.setFocus(true)
        else if shouldShowExitModel(key)
            showExitDialog()
        end if
        handled = true
    else
        if key = "right" and m.menu.hasFocus()
            m.channelGridList.setFocus(true)
        end if
        handled = true
    end if
    return handled
end function
