function redirectScreenTo(scene) as void
    currentScene = m.top
    mainScene = currentScene.getParent()
    newScene = CreateObject("roSGNode", scene)
    if mainScene = invalid
        mainScene = currentScene
    end if

    mainScene.appendChild(newScene)
    newScene.setFocus(true)
    mainScene.removeChild(currentScene)
end function

function showDialog(dialog) as void
    currentScene = m.top
    mainScene = currentScene.getParent()
    mainScene.dialog = dialog
end function

function getUserFromSection() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("user")
        return ParseJson(section.Read("user"))
    end if
    return invalid
end function

function setUserOnSection(user) as void
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("user", user)
    section.Flush()
end function

function deleteUserOnSection() as void
    section = CreateObject("roRegistrySection", "Authentication")
    section.Delete("user")
    section.Flush()
end function

function getProviderFromSection() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("providerURL")
        return section.Read("providerURL")
    end if
    return invalid
end function

function setProviderOnSection(providerURL) as void
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("providerURL", providerURL)
    section.Flush()
end function

function IsString(value as dynamic) as boolean
    return IsValid(value) and GetInterface(value, "ifString") <> invalid
end function

function IsValid(value as dynamic) as boolean
    return Type(value) <> "<uninitialized>" and value <> invalid
end function

function setVodName(name)
    section = CreateObject("roRegistrySection", "Authentication")
    section.Write("vodName", name)
    section.Flush()
end function

function getVodName() as dynamic
    section = CreateObject("roRegistrySection", "Authentication")
    if section.Exists("vodName")
        return section.Read("vodName")
    end if
    return invalid
end function