sub init()
    m.top.functionName = "getConfirmEmailResponse"
end sub

sub getConfirmEmailResponse() as string
    request = CreateObject("roUrlTransfer")
    port = CreateObject("roMessagePort")
    request.SetMessagePort(port)

    confirmEmailRequestDTO = {
        token: m.top.token,
        providerURL: m.top.providerURL,
        email: m.top.email
    }

    url = "https://" + confirmEmailRequestDTO.providerURL + "/email/confirmation?t=" + confirmEmailRequestDTO.token + "&email=" + confirmEmailRequestDTO.email
    print confirmEmailRequestDTO
    request.SetUrl(url)
    request.SetCertificatesFile("common:/certs/ca-bundle.crt")
    request.AddHeader("X-Roku-Reserved-Dev-Id", "")
    request.AddHeader("content-type", "application/json")
    request.AddHeader("X-user-agent", "cdntv-roku")
    request.AddHeader("user-agent", "cdntv-roku")
    request.InitClientCertificates()

    if (request.AsyncPostFromString(FormatJson(confirmEmailRequestDTO)))
        msg = wait(60000, port)

        if (type(msg) = "roUrlEvent")
            code = msg.GetResponseCode()
            date = CreateObject("roDateTime")
            confirmEmailResponseDTO = {
                updatedAt: date.AsSeconds(),
                status: "ok",
                data: {
                    isSent: code = 200
                },
            }

            m.top.confirmEmailResponseDTO = FormatJson(confirmEmailResponseDTO)
            return m.top.confirmEmailResponseDTO
        else if (msg = invalid)
            request.AsyncCancel()
        end if
    end if
end sub
